﻿---
title: Analyze monitors
description: To access this page, go to Observability > Uptime > Monitors. Click on a listed monitor to view more details and analyze further. The monitor detail screen...
url: https://www.elastic.co/docs/solutions/observability/uptime/analyze-monitors
products:
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Deprecated since 8.15
---

# Analyze monitors
<admonition title="Deprecated in 8.15.0.">
  Use [Synthetic monitoring](https://www.elastic.co/docs/solutions/observability/synthetics) instead of the Uptime app.
</admonition>

To access this page, go to **Observability > Uptime > Monitors**. Click on a listed monitor to view more details and analyze further.
The monitor detail screen displays several panels of information.

## Status panel

The **Status** panel displays a summary of the latest information regarding your monitor. You can view its availability, monitor ID, type, and any assigned tags. You can click a link to visit the targeted URL, view when the TLS certificate expires, and determine the amount of time elapsed since the last check.
![Uptime status panel](https://www.elastic.co/docs/solutions/images/observability-uptime-status-panel.png)

The **Monitoring from** list displays service availability per monitoring location, along with the amount of time elapsed since data was received from that location. The availability percentage is the percentage of successful checks made during the selected time period.
To display a map with each location as a pinpoint, you can toggle the availability view from list view to map view.

## Monitor duration

The **Monitor duration** chart displays the timing for each check that was performed. The visualization helps you to gain insights into how quickly requests resolve by the targeted endpoint and give you a sense of how frequently a host or endpoint was down in your selected time span.
Included on this chart is the anomaly detection (machine learning) integration. For more information, see [Inspect Uptime duration anomalies](https://www.elastic.co/docs/solutions/observability/uptime/inspect-duration-anomalies).
![Monitor duration chart](https://www.elastic.co/docs/solutions/images/observability-monitor-duration-chart.png)


## Pings over time

The **Pings over time** chart is a graphical representation of the check statuses over time. Hover over the charts to display crosshairs with specific numeric data.
![Pings over time chart](https://www.elastic.co/docs/solutions/images/observability-pings-over-time.png)


## Check history

The **History** table lists the total count of this monitor’s checks for the selected date range. To help find recent problems on a per-check basis, you can filter by `status` and `location`.
This table can help you gain insights into more granular details about recent individual data points that Heartbeat is logging about your host or endpoint.
![Monitor history list](https://www.elastic.co/docs/solutions/images/observability-uptime-history.png)