﻿---
title: Writer role
description: For users who need to create, modify, and delete monitors, provide write access. Two types of write access are outlined below: General write access: For...
url: https://www.elastic.co/docs/solutions/observability/synthetics/writer-role
products:
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Writer role
<important>
  To minimize the privileges required by the writer role, use the [setup role](https://www.elastic.co/docs/solutions/observability/synthetics/setup-role) to enable Monitor Management. This section assumes another user has already enabled Monitor Management.
</important>

For users who need to create, modify, and delete monitors, provide write access. Two types of write access are outlined below:
- **General write access**: For most users, you can use [General write access](#synthetics-write-privileges-general), which grants write access to all Kibana apps and requires little configuration.
- **Limited write access**: If you want to limit write access to the Synthetics app only, you can use [Limited write access](#synthetics-write-privileges-limited), which requires additional configuration.


## General write access

Create a **writer role**, called something like `synthetics_writer`:
1. Start with the `editor` [built-in role](https://www.elastic.co/docs/reference/elasticsearch/roles#built-in-roles-editor). This role grants full access to all features in Kibana (including the Observability solution) and read-only access to data indices.
   <note>
   The `editor` [built-in role](https://www.elastic.co/docs/reference/elasticsearch/roles#built-in-roles-editor) will grant write access to *all* Kibana apps. If you want to limit write access to the Synthetics app only, refer to [Limited write access](#synthetics-write-privileges-limited).
   </note>
2. *If the user should have permission to create, modify, and delete project monitors*, they will need an API key that can be used to `push` monitors. To create API keys, the user will also need *at least one* of the following privileges in addition to the privileges included in the `editor` built-in role:
   | Type                                                                                                       | Privilege            | Purpose                                                                                                                      |
   |------------------------------------------------------------------------------------------------------------|----------------------|------------------------------------------------------------------------------------------------------------------------------|
   | [Cluster](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-cluster) | `manage_own_api_key` | Allows access to all security-related operations on Elasticsearch API keys that are owned by the current authenticated user. |
   | [Cluster](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-cluster) | `manage_security`    | Allows access to all security-related operations such as CRUD operations on users and roles and cache clearing.              |
   | [Cluster](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-cluster) | `manage_api_key`     | Allows access to all security-related operations on Elasticsearch API keys.                                                  |


## Limited write access

If you want to limit write access to the Synthetics app only, do *not* use the `editor` [built-in role](https://www.elastic.co/docs/reference/elasticsearch/roles#built-in-roles-editor).
Instead to you can create a writer role, called something like `synthetics_writer_limited`, and start by granting the following privileges:

| Type                                                                                                         | Privilege                                       | Purpose                                       |
|--------------------------------------------------------------------------------------------------------------|-------------------------------------------------|-----------------------------------------------|
| [Index](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-indices)     | `synthetics-*`: `read`                          | Read-only access to synthetics indices.       |
| [Index](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-indices)     | `.alerts-observability.uptime.alerts-*`: `read` | Read-only access to synthetics alert indices. |
| [Kibana](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges) | `Synthetics and Uptime`: `All`                  | Access to the Synthetics app in Kibana.       |

Additional privileges will depend on the factors below.

### To restrict using Elastic’s global managed infrastructure

To restrict users assigned this role from using monitors hosted on Elastic’s global managed infrastructure:
1. Expand `Synthetics and Uptime` in the list of [Kibana](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges) privileges.
2. Toggle *Customize sub-feature privileges*.
3. Uncheck *Elastic managed locations enabled*.


### If using Private Locations

The user who initially sets up a new Private Location needs additional privileges. Users who create or update monitors hosted on that Private Location do not need any additional permissions.
The user who is setting up a new Private Location will need the following privileges when creating the agent policy in Fleet:

| Type                                                                                                         | Privilege              | Purpose                           |
|--------------------------------------------------------------------------------------------------------------|------------------------|-----------------------------------|
| [Kibana](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges) | `Fleet`: `All`         | Access to Fleet in Kibana.        |
| [Kibana](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges) | `Integrations`: `read` | Access to Integrations in Kibana. |


### If using projects

If the user should be able to create and update monitors using [projects](/docs/solutions/observability/synthetics/get-started#observability-synthetics-get-started-synthetics-project), add *at least one* of following privileges:

| Type                                                                                                       | Privilege            | Purpose                                                                                                                      |
|------------------------------------------------------------------------------------------------------------|----------------------|------------------------------------------------------------------------------------------------------------------------------|
| [Cluster](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-cluster) | `manage_own_api_key` | Allows access to all security-related operations on Elasticsearch API keys that are owned by the current authenticated user. |
| [Cluster](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-cluster) | `manage_security`    | Allows access to all security-related operations such as CRUD operations on users and roles and cache clearing.              |
| [Cluster](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-cluster) | `manage_api_key`     | Allows access to all security-related operations on Elasticsearch API keys.                                                  |