﻿---
title: Use the Synthetics Recorder
description: You can use the Synthetics Recorder to write a synthetic test by interacting with a web page and exporting journey code that reflects all the actions...
url: https://www.elastic.co/docs/solutions/observability/synthetics/use-synthetics-recorder
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Use the Synthetics Recorder
<important>
  As with any script recording technology, the Elastic Synthetics Recorder should be used as a tool to help create the main structure of the script. For simpler sites, you may be able to use the Synthetics Recorder’s output directly to create a synthetic monitor, but for more complex and dynamic sites, or to limit flakiness, you’ll likely need to edit its output before using it to create a monitor.
</important>

You can use the Synthetics Recorder to [write a synthetic test](https://www.elastic.co/docs/solutions/observability/synthetics/write-synthetic-test) by interacting with a web page and exporting journey code that reflects all the actions you took.
![Elastic Synthetics Recorder after recording a journey and clicking Export](https://www.elastic.co/docs/solutions/images/observability-synthetics-create-test-script-recorder.png)


### Set up

For information on how to download the Elastic Synthetics Recorder, go to the [download page](https://github.com/elastic/synthetics-recorder/blob/main/docs/DOWNLOAD.md).

## Record a journey

To record a journey:
1. Enter a starting URL in the search box. This URL will be the starting point of the journey script the recorder will create.
2. Click **Start** or press Enter on your keyboard. This will launch a Chromium window open to the page you specified and start recording.
3. Start interacting with the browser. This can include clicking on text, navigation, focusing on inputs like buttons and text fields, and more.
4. (Optional) You can click **Pause** to temporarily stop recording actions while you continue to interact with the browser. Click again to start recording actions again. Note: It’s especially important to [test the journey](#synthetics-recorder-test-the-journey) if you paused recording at any point.
5. When you’re done interacting with the browser window, click **Stop** or close the browser to stop recording.


## Edit a journey

Once you’ve started recording, you can use the Synthetics Recorder UI to edit steps and individual actions before generating the journey code. You can also edit the journey after you’ve stopped recording.

### Name steps

Naming steps can help make the resulting journey code easier to understand. If you provide a step name, the name will be used in both the UI and the resulting code. If you don’t name steps, the UI will show "Step 1", "Step 2", and so on, and the resulting code will use the first action in the step as the step text.
To edit a step name:
1. Hover over the current step name and click the pencil icon that appears.
2. Edit the text in the text box.
3. Click Return or Enter on your keyboard to save the updated name.


### Split into multiple steps

Steps represent groups of actions that should be completed in a specific order. Breaking a journey into steps can make it easier to read the resulting code. It can also make it easier to interpret results in the Synthetics UI since each step is displayed individually in the UI along with screenshots for convenient debugging and error tracking.
By default, the Synthetics Recorder will group all actions in a single step, but you can break actions into any number of steps.
To add a step:
1. Click the plus icon between two actions to create a new step.
2. (Optional) Consider naming the step.

Use the trash can icon to delete the step divider, adding the actions from the deleted step into the previous step.

### Edit or delete recorded actions

You can fine-tune a journey by editing actions that were generated by the recorder. You can’t change the type of command (for example, "click" or "navigate"), but you can change the value that is passed to the command.
To edit an action:
1. Hover over an action and click the pencil icon that appears.
2. Edit the value as needed.
3. Click **Save**.

To delete an action:
1. Hover over the action you want to delete and click the three dots for more options.
2. Click **Delete action**.

<important>
  If you changed or deleted any actions to ensure the journey still works, it’s especially important to [test the journey](#synthetics-recorder-test-the-journey).
</important>


### Add assertions

Assertions can play an important role in effective synthetic journeys by making determinations about the state of the page you are testing. This can include checking if an element is visible or checking the contents of a text field. You can’t generate an assertion just from interacting with the browser window. Instead, you can add assertions between generated actions.
To add an assertion:
1. Find the generated action that should be done right before you want to assert a condition.
2. Hover over that action and click the three dots for more options.
3. Click **Add assertion**. This will add a new "assert" action in the UI.
4. Provide the type of assertion, selector, and value.
5. Click **Save**.

<important>
  If you added any assertions after you’ve finished recording to ensure the journey still works, it’s especially important to [test the journey](#synthetics-recorder-test-the-journey).
</important>


## Test the journey

At any point during or after the recording process concludes, you can test your script.
When you click the **Test** button, Elastic Synthetics will run the journey. As the test runs, the recorder will display results on a per-step basis. If there are any errors that prevent the journey from running, the recorder will display the relevant error message to help you debug.
<important>
  If you paused recording, updated actions, or added assertions manually in the recorder it is especially important that you test the journey to  verify that the actions work in sequence.
</important>


## Export

When you are satisfied with journey you’ve created, you can export it from the recorder.
Click **Export** to view the final journey code. From there you can use the code by:
- Copy and pasting code containing all steps into a new or existing [Synthetics project](https://www.elastic.co/docs/solutions/observability/synthetics/create-monitors-with-projects) or an [inline monitor](https://www.elastic.co/docs/solutions/observability/synthetics/create-monitors-ui).
- Click **Export** to save a JavaScript file containing all steps.

You can also check **Export as project** and either copy and paste or **Export** to get the full journey code including `journey` and imports for all dependencies.