﻿---
title: Synthetics support matrix
description: There are various components that make up the Synthetics solution, which are supported in the following configurations: GA support: 8.8.0 and higher,...
url: https://www.elastic.co/docs/solutions/observability/synthetics/support-matrix
products:
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Synthetics support matrix
There are various components that make up the Synthetics solution, which are supported in the following configurations:

## Synthetics app

- **GA support**: 8.8.0 and higher
- **Notes**:
  - For creating and managing lightweight and browser monitors configured through the [Synthetics app](https://www.elastic.co/docs/solutions/observability/synthetics/create-monitors-ui)
- For reporting for lightweight and browser monitors configured through the [Synthetics app](https://www.elastic.co/docs/solutions/observability/synthetics/create-monitors-ui) and/or [Project monitors](https://www.elastic.co/docs/solutions/observability/synthetics/create-monitors-with-projects)


## Project monitors

- **GA support**: 8.8.0 and higher
- **Notes**: For creating and managing lightweight and browser monitors configured as [Project monitors](https://www.elastic.co/docs/solutions/observability/synthetics/create-monitors-with-projects)


## Elastic’s global managed testing infrastructure

- **GA support**: 8.8.0 and higher
- **Notes**: Elastic’s infrastructure for running lightweight and browser monitors configured through the [Synthetics app](https://www.elastic.co/docs/solutions/observability/synthetics/create-monitors-ui) and/or [Project monitors](https://www.elastic.co/docs/solutions/observability/synthetics/create-monitors-with-projects)
  Executing synthetic tests on Elastic’s global managed testing infrastructure incurs an additional charge. Tests are charged under one of two new billing dimensions depending on the monitor type. For *browser monitor* usage, there is a fee per test run. For *lightweight monitor* usage, there is a fee per region in which you run any monitors regardless of the number of test runs. For more details, refer to [full details and current pricing](https://www.elastic.co/pricing).


## Private Locations

- **GA support**: 8.8.0 and higher
- **Notes**:
  - For running lightweight and browser monitors from your self-managed infrastructure
- Relies on the Synthetics integration 1.0.0 or above
  - Any *inline* or *Zip URL* monitors configured with the beta Synthetics integration prior to 1.0.0, are not supported and will stop running in the future
- Shipped as multiple `elastic-agent` variants:
  - `elastic-agent-complete`, exclusively provided as a Docker image which includes all dependencies required to run browser, TCP, HTTP, and ICMP monitors.
- `elastic-agent` which only supports TCP, HTTP, and ICMP monitors.
- Must have a direct connection to Elasticsearch
  - Do not configure any ingest pipelines or Logstash output


## Heartbeat with Uptime

<applies-to>
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Deprecated since 8.15
</applies-to>

- **GA support**: As defined in the standard [Support matrix](https://www.elastic.co/support/matrix)
- **Notes**:
  - For running lightweight monitors via YML configuration running on self-managed infrastructure
- Browser-based monitors are not supported in this configuration


## Standalone Elastic Agent

- **GA support**: As defined in the standard [Support matrix](https://www.elastic.co/support/matrix)
- **Notes**:
  - For running lightweight monitors via YML configuration running on self-managed infrastructure with standalone Elastic Agent
- Browser-based monitors are not supported in this configuration
- Results for monitors configured using the standalone Elastic Agent are available in the Uptime app (*not* the Synthetics app)


## Synthetics Recorder

System requirements:
- macOS - High Sierra and newer
- Windows - Windows 10 and newer
- Linux:
  - Ubuntu - 14.04 and newer
- Fedora - 24 and newer
- Debian - 8 and newer


## Output to Elasticsearch

Synthetics must have a direct connection to Elasticsearch, whether running monitors from Elastic’s global managed testing infrastructure or from Private Locations.
Do not configure any ingest pipelines or output via Logstash as this will prevent Synthetics from working properly and is not supported.