﻿---
title: Scripting browser monitors
description: Browser monitors are a type of synthetic monitor. Synthetic monitoring extends traditional end-to-end testing techniques because it allows your tests...
url: https://www.elastic.co/docs/solutions/observability/synthetics/scripting-browser-monitors
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Scripting browser monitors
Browser monitors are a type of synthetic monitor. Synthetic monitoring extends traditional end-to-end testing techniques because it allows your tests to run continuously on the cloud. With synthetic monitoring, you can assert that your application continues to work after a deployment by reusing the same journeys that you used to validate the software on your machine.
You can use synthetic monitors to detect bugs caused by invalid states you couldn’t predict and didn’t write tests for. Synthetic monitors can also help you catch bugs in features that don’t get much traffic by allowing you to periodically simulate users' actions.
Start by learning the basics of synthetic monitoring, including how to:
- [Write a synthetic test](https://www.elastic.co/docs/solutions/observability/synthetics/write-synthetic-test)
- [Test locally](/docs/solutions/observability/synthetics/write-synthetic-test#synthetics-test-locally)
- [Configure individual browser monitors](https://www.elastic.co/docs/solutions/observability/synthetics/configure-individual-browser-monitors)
- [Work with params and secrets](https://www.elastic.co/docs/solutions/observability/synthetics/work-with-params-secrets)
- [Use the Synthetics Recorder](https://www.elastic.co/docs/solutions/observability/synthetics/use-synthetics-recorder)

![Diagram of the lifecycle of a synthetic monitor: write a test](https://www.elastic.co/docs/solutions/images/observability-synthetic-monitor-lifecycle.png)