﻿---
title: Scale and architect a Synthetics deployment
description: Use these advanced considerations when using the Synthetics app for large and complex use cases. In complex environments it’s common to have multiple...
url: https://www.elastic.co/docs/solutions/observability/synthetics/scale-architect-synthetics-deployment
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Scale and architect a Synthetics deployment
Use these advanced considerations when using the Synthetics app for large and complex use cases.

## Do not use the Synthetics UI with CCS/CCR

<applies-to>
  - Elastic Stack: Generally available
</applies-to>

In complex environments it’s common to have multiple task-specific Elastic Stack deployments with one  centralized overview cluster using CCS or CCR to centralize Kibana dashboards and apps. **Do not use this pattern with the Synthetics UI**. Instead, configure your synthetic monitors directly on the Kibana instance where you want to view and manage them.
You may, however, use Dashboards and the Discover feature with CCS to view `synthetics-*` indices.
The Synthetics UI does *not* work with CCS/CCR because it would limit the rich user experience that the Synthetics UI provides. Unlike the majority of Kibana apps, the Synthetics UI relies heavily on state stored in Kibana shared objects in order to provide a rich user experience. Because Kibana saved objects cannot be shared via CCS/CCR, the Synthetics UI will not show any user data even if CCS/CCR is configured.

## Manage large numbers of Synthetic monitors with tags

When managing larger numbers of synthetic monitors, use tags to keep them organized. Many of the views in the Synthetics UI are tag-aware and can group data by tag.

## Create custom dashboards

If we don't provide a UI for your exact needs, you can use [dashboards](https://www.elastic.co/docs/explore-analyze/dashboards) to build custom visualizations. For a complete accounting of fields used by the Synthetics UI, refer to [Heartbeat's exported fields](https://www.elastic.co/docs/reference/beats/heartbeat/exported-fields).