﻿---
title: Reader role
description: For users who need to view and create visualizations that access Synthetics data, provide read access. Two types of read access are outlined below: General...
url: https://www.elastic.co/docs/solutions/observability/synthetics/reader-role
products:
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Reader role
For users who need to view and create visualizations that access Synthetics data, provide read access. Two types of read access are outlined below:
- **General read access**: For most users, you can use [General read access](#synthetics-read-privileges-general), which grants read access to all Kibana apps and requires little configuration.
- **Limited read access**: If you want to limit read access to the Synthetics app only, you can use [Limited read access](#synthetics-read-privileges-limited), which requires additional configuration.


## General read access

For users who only need to view results in Kibana, use the `viewer` [built-in role](https://www.elastic.co/docs/reference/elasticsearch/roles).

## Limited read access

If you want to limit read access to the Synthetics app only, do *not* use the `viewer` [built-in role](https://www.elastic.co/docs/reference/elasticsearch/roles).
Instead to you can create a reader role, called something like `synthetics_reader_limited`, and grant the following privileges:

| Type                                                                                                         | Privilege                                       | Purpose                                       |
|--------------------------------------------------------------------------------------------------------------|-------------------------------------------------|-----------------------------------------------|
| [Index](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-indices)     | `synthetics-*`: `read`                          | Read-only access to synthetics indices.       |
| [Index](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-indices)     | `.alerts-observability.uptime.alerts-*`: `read` | Read-only access to synthetics alert indices. |
| [Kibana](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges) | `Synthetics and Uptime`: `read`                 | Access to the Synthetics app in Kibana.       |