﻿---
title: Monitor resources on private networks
description: To monitor resources on private networks you can either: Allow Elastic’s global managed infrastructure to access your private endpoints.Use Elastic Agent...
url: https://www.elastic.co/docs/solutions/observability/synthetics/monitor-resources-on-private-networks
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Monitor resources on private networks
To monitor resources on private networks you can either:
- Allow Elastic’s global managed infrastructure to access your private endpoints.
- Use Elastic Agent to create a Private Location.

Private Locations via Elastic Agent require only outbound connections from your network, while allowing Elastic’s global managed infrastructure to access a private endpoint requires inbound access, thus posing an additional risk that users must assess.

## Allow access to your private network

To give Elastic’s global managed infrastructure access to a private endpoint, use IP address filtering, HTTP authentication, or both.
To grant access via IP, use [this list of egress IPs](https://manifest.synthetics.elastic-cloud.com/v1/ip-ranges.json). The addresses and locations on this list may change, so automating updates to filtering rules is recommended. IP filtering alone will allow all users of Elastic’s global managed infrastructure access to your endpoints, if this is a concern consider adding additional protection via user/password authentication via a proxy like nginx.

## Monitor via a private agent

Private Locations allow you to run monitors from your own premises. Before running a monitor on a Private Location, you’ll need to:
- [Set up Fleet Server and Elastic Agent](#synthetics-private-location-fleet-agent).
- [Connect Fleet to the Elastic Stack](#synthetics-private-location-connect) and enroll an Elastic Agent in Fleet.
- [Add a Private Location](#synthetics-private-location-add) in the Synthetics UI.

<important>
  Private Locations running through Elastic Agent must have a direct connection to Elasticsearch. Do not configure any ingest pipelines, or output via Logstash as this will prevent Synthetics from working properly and is not [supported](https://www.elastic.co/docs/solutions/observability/synthetics/support-matrix).
</important>


## Set up Fleet Server and Elastic Agent

Start by setting up Fleet Server and Elastic Agent:
- **Set up Fleet Server**: If you are using Elastic Cloud, Fleet Server will already be provided and you can skip this step. To learn more, refer to [Set up Fleet Server](https://www.elastic.co/docs/reference/fleet/fleet-server).
- **Create an agent policy**: For more information on agent policies and creating them, refer to [Elastic Agent policy](/docs/reference/fleet/agent-policy#create-a-policy).

<important>
  A Private Location should be set up against an agent policy that runs on a single Elastic Agent. The Elastic Agent must be **enrolled in Fleet** (Private Locations cannot be set up using **standalone** Elastic Agents). Do *not* run the same agent policy on multiple agents being used for Private Locations, as you may end up with duplicate or missing tests. Private Locations do not currently load balance tests across multiple Elastic Agents. See [Scaling Private Locations](#synthetics-private-location-scaling) for information on increasing the capacity within a Private Location.By default Private Locations are configured to allow two simultaneous browser tests and an unlimited number of lightweight checks. As a result, if more than two browser tests are assigned to a particular Private Location, there may be a delay to run them.
</important>


## Connect to the Elastic Stack or your Observability Serverless project

After setting up Fleet, you’ll connect Fleet to the Elastic Stack or your Observability Serverless project and enroll an Elastic Agent in Fleet.
Elastic provides Docker images that you can use to run Fleet and an Elastic Agent more easily. Additional installation methods can be found on the [Elastic Agent installation guide](https://www.elastic.co/docs/reference/fleet/install-elastic-agents).
<important>
  For running browser monitors on Private Locations, you *must* use one of the `elastic-agent-complete` Docker image variants in a containerized environment. The standard Elastic Agent variant only supports TCP, ICMP, and HTTP monitors.
</important>

To pull the Docker image run:
<tab-set>
  <tab-item title="elastic-agent-complete">
    ```sh
    # Supports all monitor types: TCP, ICMP, HTTP and Browser
    docker pull docker.elastic.co/elastic-agent/elastic-agent-complete:9.3.0
    ```
  </tab-item>

  <tab-item title="elastic-agent">
    ```shell
    # Supports TCP, ICMP and HTTP monitors
    docker pull docker.elastic.co/elastic-agent/elastic-agent:9.3.0
    ```
  </tab-item>
</tab-set>

You can download and install a specific version of the Elastic Stack by replacing `{{version.stack}}` with the version number you want. For example, you can replace `{{version.stack}}` with 9.0.0.
Then enroll and run an Elastic Agent. You’ll need an enrollment token and the URL of the Fleet Server. You can use the default enrollment token for your policy or create new policies and [enrollment tokens](https://www.elastic.co/docs/reference/fleet/fleet-enrollment-tokens) as needed.
For more information on running Elastic Agent with Docker, refer to [Run Elastic Agent in a container](https://www.elastic.co/docs/reference/fleet/elastic-agent-container).
<tab-set>
  <tab-item title="elastic-agent-complete">
    ```shell
    docker run \
      --env FLEET_ENROLL=1 \
      --env FLEET_URL={fleet_server_host_url} \
      --env FLEET_ENROLLMENT_TOKEN={enrollment_token} \
      --cap-add=NET_RAW \
      --cap-add=SETUID \
      --rm docker.elastic.co/elastic-agent/elastic-agent-complete:9.3.0
    ```
    The `elastic-agent-complete` container, when running as Synthetics Private Locations, requires additional capabilities to operate correctly. Ensure `NET_RAW` and `SETUID` are enabled on the container.
  </tab-item>

  <tab-item title="elastic-agent">
    ```shell
    docker run \
      --env FLEET_ENROLL=1 \
      --env FLEET_URL={fleet_server_host_url} \
      --env FLEET_ENROLLMENT_TOKEN={enrollment_token} \
      --cap-add=NET_RAW \
      --cap-add=SETUID \
      --rm docker.elastic.co/elastic-agent/elastic-agent:9.3.0
    ```
    The `elastic-agent` container, when running as Synthetics Private Locations, requires additional capabilities to operate correctly. Ensure `NET_RAW` and `SETUID` are enabled on the container.
  </tab-item>
</tab-set>

<note>
  You may need to set other environment variables. Learn how in [Elastic Agent environment variables guide](https://www.elastic.co/docs/reference/fleet/agent-environment-variables).
</note>


## Add a Private Location

When the Elastic Agent is running you can add a new Private Location in the UI:
1. Find `Synthetics` in the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Go to **Settings**.
3. Go to the **Private Locations** tab.
4. Click **Create location**.
5. Give your new location a unique _Location name_.
6. Select the _Agent policy_ you created above.
7. (Optional) In _Tags_ select [tags](https://www.elastic.co/docs/explore-analyze/find-and-organize/tags) to assign to this location.
8. (Optional) In _Spaces_ specify the [spaces](https://www.elastic.co/docs/deploy-manage/manage-spaces) where this location will be available.
9. Click **Save**.

<important>
  It is not currently possible to use custom CAs for synthetics browser tests in private locations without following a workaround. To learn more about the workaround, refer to the following GitHub issue: [elastic/synthetics#717](https://github.com/elastic/synthetics/issues/717).
</important>


## Scaling Private Locations

By default Private Locations are configured to allow two simultaneous browser tests, and an unlimited number of lightweight checks. These limits can be set via the environment variables `SYNTHETICS_LIMIT_{{TYPE}}`, where `{{TYPE}}` is one of `BROWSER`, `HTTP`, `TCP`, and `ICMP` for the container running the Elastic Agent docker image.

### CPU and RAM requirements

It is critical to allocate enough memory and CPU capacity to handle configured limits. Resource requirements will vary depending on simultaneous workload and monitor complexity:
**For browser monitors**: Start by allocating at least 2 GiB of memory and two cores _per browser instance_ to ensure consistent performance and avoid out-of-memory errors. Then adjust as needed.
**For tcp, http, icmp**: Much less memory is needed, start by allocating at least 512MiB of memory and two cores _globally_. While this will be enough to run a large number of lightweight monitors, it is recommended to track the resource usage and adjust accordingly.
Example: For a private location expected to run 2 concurrent browser monitors and 100 HTTP checks, the recommended allocation is 2 * (2 GiB + 2 vCPU) + (512 MiB + 2 vCPU) => 4,5 GiB + 6 vCPU.

### Known limitations on vertical scaling

- A single private location will not scale beyond 10,000 monitors. Exceeding this number will result in agent degradation and inconsistent execution, regardless of the resources allocated.
- Complex monitor configuration can disproportionately increase the private location policy size, leading to agent communication errors and degradation even if the limit mentioned above hasn't been reached.

If you're facing one of these scenarios, it is likely that the private location has grown too large and needs to be split into smaller locations, each alloted a portion of the original location monitors.

## Next steps

Now you can add monitors to your Private Location in [the Synthetics UI](https://www.elastic.co/docs/solutions/observability/synthetics/create-monitors-ui) or using the [Elastic Synthetics library’s `push` method](https://www.elastic.co/docs/solutions/observability/synthetics/create-monitors-with-projects).