﻿---
title: Migrate from the Elastic Synthetics integration
description: The Elastic Synthetics integration is a method for creating synthetic monitors that is no longer recommended. You should not use the Elastic Synthetics...
url: https://www.elastic.co/docs/solutions/observability/synthetics/migrate-from-elastic-synthetics-integration
products:
  - Elastic Observability
applies_to:
  - Elastic Stack: Generally available
---

# Migrate from the Elastic Synthetics integration
The Elastic Synthetics integration is a method for creating synthetic monitors that is no longer recommended.
You should *not* use the Elastic Synthetics integration to set up new monitors and should make a plan to migrate existing monitors to use either **Project monitors** or the **Synthetics app**:
- With Elastic **Project monitors**, you write tests in an external version-controlled project and use a CLI tool to push monitors to the Elastic Stack.
- The **Synthetics app** is an application in Kibana that you can use to configure and create monitors using a user interface.


## Compare approaches

Below is a comparison of how you used the Elastic Agent integration to create monitors and how you’ll use the Synthetics app or projects to create monitors:
**Supported monitors**:
- **Elastic Agent integration**: Supported both lightweight and browser monitors
- **Projects or the Synthetics app**: Supports both lightweight and browser monitors

**Where monitors run ([read more](#synthetics-migrate-integration-location))**:
- **Elastic Agent integration**: You had to run monitors on your infrastructure
- **Projects or the Synthetics app**: You can run monitors on both:
  - Your infrastructure using [Private Locations](https://www.elastic.co/docs/solutions/observability/synthetics/monitor-resources-on-private-networks)
- Elastic’s global managed infrastructure

**Where you configure monitors**:
- **Elastic Agent integration**: You could configure monitors using:
  - A user interface in Kibana (all monitor types)
- Code in an external, version-controlled project (browser monitors *only*)
- **Projects or the Synthetics app**: You can configure monitors using:
  - A user interface in Kibana (all lightweight monitors, browser monitors via inline script only)
- Code in an external, version-controlled project (all monitor types)

**How to use projects ([read more](#synthetics-migrate-integration-projects))**:
- **Elastic Agent integration**:
  1. Created a project that uses `@elastic/synthetics`.
2. Wrote journeys in JavaScript or TypeScript files.
3. Zipped the entire project.
4. Configured and created the monitor in the Integrations UI by adding a ZIP URL that pointed to the location of the project.
- **Projects or the Synthetics app**:
  1. Create a project that uses `@elastic/synthetics`.
2. Configure lightweight monitors in YAML files.
3. Write journeys in JavaScript or TypeScript files and configure individual monitors in your journey code using `monitor.use` or configure all monitors using the `synthetics.config.ts` file.
4. Use the `elastic/synthetics push` command to create monitors.

Find more details in [Use Project monitors](https://www.elastic.co/docs/solutions/observability/synthetics/create-monitors-with-projects).
**How to use the UI ([read more](#synthetics-migrate-integration-ui))**:
- **Elastic Agent integration**:
  1. Went to the **Integrations** page in Kibana.
2. Searched for and added the **Elastic Synthetics** integration.
3. Configured the monitor.
4. Created the monitor.
- **Projects or the Synthetics app**:
  1. Go to **Synthetics** in Kibana.
2. Go to **Management**.
3. Click **Create monitor**.
4. Configure the monitor.
5. Create the monitor.

Find more details in [Use the Synthetics app](https://www.elastic.co/docs/solutions/observability/synthetics/create-monitors-ui).

## Where monitors run

If you want to continue hosting on your infrastructure, create a Private Location before creating monitors. If you already have an Elastic Agent running using `elastic-agent` or any of its variants, you can [add it as a new Private Location](/docs/solutions/observability/synthetics/monitor-resources-on-private-networks#synthetics-private-location-add) in the Synthetics app.
<note>
  Only the `elastic-agent-complete` image (and its `wolfi` variant) allows you to run Synthetic Browser tests.
</note>

To create a new Private Location from scratch, follow the instructions in [Monitor resources on private networks](https://www.elastic.co/docs/solutions/observability/synthetics/monitor-resources-on-private-networks).
Alternatively, you can start hosting on Elastic’s global managed infrastructure. With Elastic’s global managed testing infrastructure, you can create and run monitors in multiple locations without having to manage your own infrastructure. Elastic takes care of software updates and capacity planning for you.
Executing synthetic tests on Elastic’s global managed testing infrastructure incurs an additional charge. Tests are charged under one of two new billing dimensions depending on the monitor type. For *browser monitor* usage, there is a fee per test run. For *lightweight monitor* usage, there is a fee per region in which you run any monitors regardless of the number of test runs. For more details, refer to [full details and current pricing](https://www.elastic.co/pricing).

## How to use projects

If you already have an external project you were adding via a ZIP URL you can use the same project, but you will have to make some changes.
First, upgrade the existing project to use the latest version of `@elastic/synthetics`:
1. Run `npm install -g @elastic/synthetics@latest` to install the latest version of the CLI.
2. Upgrade your existing project to use new project settings:
   1. Run `npm @elastic/synthetics init <path-to-existing-project>`.
2. Respond to all prompts provided by the CLI.
   <note>
   To ensure that your project will work with the latest version of Elastic Synthetics, the CLI will create a new configuration file on `init`, but you will see a prompt asking if you would like to continue before overwriting an existing configuration file.
   </note>
3. Review updated files and directories, including:
   1. `journeys/` will contain sample journey code. Move existing journey files into this directory.
2. `synthetics.config.ts` will contain updated default settings needed for the upgraded project.
3. `package.json` will contain updated NPM settings for your project.
   <note>
   If there is already a `package.json` file in the directory when you run `init`, the synthetics agent will *not* create a new `package.json` file. Instead it will modify the existing `package.json` file to:
   - Add `@elastic/synthetics` library to the dependencies if it’s not already present.
   - Add a `test` and `push` script if they are not already present.
   </note>
4. `.github/` will contain sample workflow files to use with GitHub Actions.

Then, you can further configure monitors as needed. In the upgraded project, you’ll use code (instead of the Integrations UI) to define settings like the name of the monitor and the frequency at which it will run. There are two ways you can configure monitors using code:
- For individual monitors, use `monitor.use` directly in the journey code. Read more in [Configure individual monitors](https://www.elastic.co/docs/solutions/observability/synthetics/configure-individual-browser-monitors).
- To configure all monitors at once, use the synthetics configuration file. Read more in [Configure projects](https://www.elastic.co/docs/solutions/observability/synthetics/configure-projects).

Finally, you’ll create monitors using `push` instead of by adding a ZIP URL in the Integrations UI. This will require an API token. Read more in [`@elastic/synthetics push`](/docs/solutions/observability/synthetics/cli#elastic-synthetics-push-command).
Optionally, you can also add lightweight monitors to the project in YAML files. Read more about adding lightweight monitors to projects in [Configure lightweight monitors](https://www.elastic.co/docs/solutions/observability/synthetics/configure-lightweight-monitors).
For more information on getting started with projects, refer to [Use Project monitors](https://www.elastic.co/docs/solutions/observability/synthetics/create-monitors-with-projects).

## How to use the UI

If you created monitors solely via the Elastic Synthetics integration UI, you can recreate monitors in the Synthetics app.
The configuration options in the Synthetics app look very similar to the Elastic Synthetics integration UI with a few exceptions. In the Synthetics app:
1. You will select one or more locations for each monitor.
2. You cannot use a ZIP URL for browser monitors. Use projects instead.
3. You can test the configuration (including the journey for browser monitors) using **Run test** before creating the monitor.

For more information on getting started with the Synthetics app, refer to [Use the Synthetics app](https://www.elastic.co/docs/solutions/observability/synthetics/create-monitors-ui).