﻿---
title: Grant users access to secured resources
description: 
url: https://www.elastic.co/docs/solutions/observability/synthetics/grant-access-to-secured-resources
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Grant users access to secured resources
<applies-switch>
  <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
    Typically you need to create the following separate roles:
    - [Setup role](https://www.elastic.co/docs/solutions/observability/synthetics/setup-role) for enabling Monitor Management.
    - [Writer role](https://www.elastic.co/docs/solutions/observability/synthetics/writer-role)  for creating, modifying, and deleting monitors.
    - [Reader role](https://www.elastic.co/docs/solutions/observability/synthetics/reader-role) for Kibana users who need to view and create visualizations that access Synthetics data.
    Elasticsearch security features provides [built-in roles](https://www.elastic.co/docs/reference/elasticsearch/roles) that grant a subset of the privileges needed by Synthetics users. When possible, assign users the built-in roles to minimize the affect of future changes on your security strategy. If no built-in role is available, you can assign users the privileges needed to accomplish a specific task.In general, you'll work with the following privilege types:
    - **Elasticsearch cluster privileges**: Manage the actions a user can perform against your cluster.
    - **Elasticsearch index privileges**: Control access to the data in specific indices your cluster.
    - **Kibana space privileges**: Grant users write or read access to features and apps within Kibana.
  </applies-item>

  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    - **Viewer**:
      - View and create visualizations that access Synthetics data.
    - **Editor**:
      - Create, modify, and delete monitors.
    - View and create visualizations that access Synthetics data.
    - **Admin**:
      - Full access to project management, properties, and security privileges.
    - Create, modify, and delete monitors.
    - View and create visualizations that access Synthetics data.
    Read more about user roles in [Assign user roles and privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles).
  </applies-item>
</applies-switch>