﻿---
title: Synthetics Encryption and Security
description: Elastic Synthetics was designed with security in mind encrypting both persisted and transmitted data. This page catalogs the points within Elastic Synthetics...
url: https://www.elastic.co/docs/solutions/observability/synthetics/encryption-security
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Synthetics Encryption and Security
Elastic Synthetics was designed with security in mind encrypting both persisted and transmitted data. This page catalogs the points within Elastic Synthetics where data is either stored or transmitted in an encrypted fashion.

## Synthetics UI (Kibana App)

Data is stored in [Kibana Secure Saved Objects](https://www.elastic.co/docs/deploy-manage/security/secure-saved-objects), with sensitive fields encrypted. These fields include your script source, params, and global params.

## Synthetics Service

The Global Elastic Synthetics Service performs all communication of sensitive data (both internally, and with Kibana) over encrypted connections and encrypts all data persisted to disk as well.

## Synthetics Private Locations

In Kibana configuration for private locations is stored in two places, Synthetics saved objects which always encrypt sensitive fields using [Kibana Secure Saved Objects](https://www.elastic.co/docs/deploy-manage/security/secure-saved-objects) and also in Fleet, which uses unencrypted saved objects restricted by user permissions. For Elastic Cloud customers all data is secured on disk regardless of whether additional saved object encryption is present. See our [Cloud Security Statement](https://www.elastic.co/cloud/security) for more information. We recommend that self-managed customers encrypt disks for their Elasticsearch instances if this is a concern.
All data is encrypted in transit. See [Elastic Agent configuration encryption](https://www.elastic.co/docs/reference/fleet/_agent_configuration_encryption) for more details.