﻿---
title: Configure Synthetics settings
description: There are several Synthetics settings you can adjust in Observability. Alerting enables you to detect complex conditions using rules across Observability...
url: https://www.elastic.co/docs/solutions/observability/synthetics/configure-settings
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Configure Synthetics settings
There are several Synthetics settings you can adjust in Observability.

## Alerting

Alerting enables you to detect complex conditions using **rules** across Observability and send a notification using **connectors**.
When you create a new synthetic monitor, new default synthetics rules will be applied. To edit the default rules:
1. Click **Alerts and rules** in the top bar.
2. Select a rule to open a panel where you can edit the rule’s configuration:
   - **Monitor status rule** for receiving notifications for errors and outages.
- **TLS certificate rule** for receiving notifications when one or more of your HTTP or TCP lightweight monitors has a TLS certificate expiring within a specified threshold or when it exceeds an age limit.

However, the automatically created Synthetics internal alert is intentionally preconfigured, and some configuration options can’t be changed. For example, you can’t change how often it checks the rule.
If you need specific alerting behavior, set up a different rule. To view all existing rules or create a new rule:
1. Click **Alerts and rules** in the top bar.
2. Click **Manage rules** to go to the *Rules* page.

On the *Rules* page, you can manage the default synthetics rules including snoozing rules, disabling rules, deleting rules, and more.
![Rules page with default Synthetics rules](https://www.elastic.co/docs/solutions/images/observability-synthetics-settings-disable-default-rules.png)

<note>
  You can enable and disable default alerts for individual monitors in a few ways:
  - In the Synthetics UI when you [create a monitor](https://www.elastic.co/docs/solutions/observability/synthetics/create-monitors-ui).
  - In the Synthetics UI *after* a monitor is already created, on the **Monitors** page or on the **Edit monitor** page for the monitor.
  - In Synthetics projects when [configuring a lightweight monitor](https://www.elastic.co/docs/solutions/observability/synthetics/configure-lightweight-monitors).
</note>

In the **Alerting** tab on the Synthetics Settings page, you can add and configure connectors. If you are running in Elastic Cloud, then an SMTP connector will automatically be configured, allowing you to easily set up email alerts. Read more about all available connectors in [Action types](https://www.elastic.co/docs/solutions/observability/incident-management/create-an-apm-anomaly-rule).
![Alerting tab on the Synthetics Settings page in Kibana](https://www.elastic.co/docs/solutions/images/observability-synthetics-settings-alerting.png)


## Private Locations

Private Locations allow you to run monitors from your own premises.
In the **Private Locations** tab, you can add and manage Private Locations. After you [Set up Fleet Server and Elastic Agent](/docs/solutions/observability/synthetics/monitor-resources-on-private-networks#synthetics-private-location-fleet-agent) and [Connect to the Elastic Stack or your serverless Observability project](/docs/solutions/observability/synthetics/monitor-resources-on-private-networks#synthetics-private-location-connect), this is where you will add the Private Location so you can specify it as the location for a monitor created using the Synthetics UI or a Synthetics project.
![Private Locations tab on the Synthetics Settings page in Kibana](https://www.elastic.co/docs/solutions/images/observability-synthetics-settings-private-locations.png)


## Global parameters

Global parameters can be defined once and used across the configuration of lightweight and browser-based monitors.
In the **Global parameters** tab, you can define variables and parameters. This is one of several methods you can use to define variables and parameters. To learn more about the other methods and which methods take precedence over others, see [Work with params and secrets](https://www.elastic.co/docs/solutions/observability/synthetics/work-with-params-secrets).
![Global parameters tab on the Synthetics Settings page in Kibana](https://www.elastic.co/docs/solutions/images/observability-synthetics-settings-global-parameters.png)


## Data retention

When you set up a synthetic monitor, data from the monitor is saved in [Elasticsearch data streams](https://www.elastic.co/docs/manage-data/data-store/data-streams), an append-only structure in Elasticsearch. You can customize how long synthetics data is stored by creating your own index lifecycle policy and attaching it to the relevant custom Component Template.
In the **Data retention** tab, use the links to jump to the relevant policy for each data stream. Learn more about the data included in each data stream in [Manage data retention](https://www.elastic.co/docs/solutions/observability/synthetics/manage-data-retention).
![Data retention tab on the Synthetics Settings page in Kibana](https://www.elastic.co/docs/solutions/images/observability-synthetics-settings-data-retention.png)


## Project API keys

Project API keys are used to push project monitors remotely from a CLI or CD pipeline.
In the **Project API keys** tab, you can generate project API keys to use with your projects. Learn more about using API keys in [Use Project monitors](https://www.elastic.co/docs/solutions/observability/synthetics/create-monitors-with-projects).
<important>
  **In an Elastic Stack deployment**, to create a Project API key you must be logged into Kibana as a user with the privileges described in [Writer role](https://www.elastic.co/docs/solutions/observability/synthetics/writer-role).In a serverless project, to create a Project API key you must be logged in as a user with [Editor](https://www.elastic.co/docs/solutions/observability/synthetics/grant-access-to-secured-resources) access.
</important>

![Project API keys tab on the Synthetics Settings page in Kibana](https://www.elastic.co/docs/solutions/images/observability-synthetics-settings-api-keys.png)