﻿---
title: Use the Synthetics CLI
description: Elastic uses the @elastic/synthetics Node.js library to run synthetic browser tests and report the test results. The library also provides a CLI to help...
url: https://www.elastic.co/docs/solutions/observability/synthetics/cli
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Use the Synthetics CLI
## `@elastic/synthetics`

Elastic uses the [@elastic/synthetics](https://www.npmjs.com/package/@elastic/synthetics) Node.js library to run synthetic browser tests and report the test results. The library also provides a CLI to help you scaffold, develop/run tests locally, and push tests to Kibana.
```sh
npx @elastic/synthetics [options] [files] [dir]
```

You will not need to use most command line flags. However, there are some you may find useful:
<definitions>
  <definition term="--match <string>">
    run tests with a name or tags that match the given glob pattern.
  </definition>
  <definition term="--tags Array<string>">
    run tests with the given tags that match the given glob pattern.
  </definition>
  <definition term="--pattern <string>">
    RegExp pattern to match journey files in the current working directory. Defaults to `/*.journey.(ts|js)$/`, which matches files ending with `.journey.ts` or `.journey.js`.
  </definition>
  <definition term="--params <jsonstring>">
    JSON object that defines any variables your tests require. Read more in [Work with params and secrets](https://www.elastic.co/docs/solutions/observability/synthetics/work-with-params-secrets).
    Params passed will be merged with params defined in your [`synthetics.config.js` file](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-params). Params defined via the CLI take precedence.
  </definition>
  <definition term="--playwright-options <jsonstring>">
    JSON object to pass in custom Playwright options for the agent. For more details on relevant Playwright options, refer to the [the configuration docs](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-playwright-options).
    Options passed will be merged with Playwright options defined in your [`synthetics.config.js` file](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-playwright-options). Options defined via the CLI take precedence.
  </definition>
  <definition term="--screenshots <on|off|only-on-failure>">
    Control whether or not to capture screenshots at the end of each step. Options include `'on'`, `'off'`, or `'only-on-failure'`.
    This can also be set in the configuration file using [`monitor.screenshot`](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-monitor). The value defined via the CLI will take precedence.
  </definition>
  <definition term="-c, --config <string>">
    Path to the configuration file. By default, test runner looks for a `synthetics.config.(js|ts)` file in the current directory. Synthetics configuration provides options to configure how your tests are run and pushed to Elastic. Allowed options are described in the [configuration file](https://www.elastic.co/docs/solutions/observability/synthetics/configure-projects).
  </definition>
  <definition term="--reporter <json|junit|buildkite-cli|default>">
    One of `json`, `junit`, `buildkite-cli`, or `default`. Use the JUnit or Buildkite reporter to provide easily parsed output to CI systems.
  </definition>
  <definition term="--inline">
    Instead of reading from a file, `cat` inline scripted journeys and pipe them through `stdin`. For example, `cat path/to/file.js | npx @elastic/synthetics --inline`.
  </definition>
  <definition term="--no-throttling">
    Does not apply throttling.
    Throttling can also be disabled in the configuration file using [`monitor.throttling`](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-monitor). The value defined via the CLI will take precedence.
  </definition>
</definitions>

<note>
  Network throttling for browser based monitors is disabled. See this [documention](https://github.com/elastic/synthetics/blob/main/docs/throttling.md) for more details.
</note>

<definitions>
  <definition term="--no-headless">
    Runs with the browser in headful mode.
    This is the same as setting [Playwright’s `headless` option](https://playwright.dev/docs/api/class-testoptions#test-options-headless) to `false` by running `--playwright-options '{"headless": false}'`.
  </definition>
</definitions>

<note>
  Headful mode should only be used locally to see the browser and interact with DOM elements directly for testing purposes. Do not attempt to run in headful mode when running through Elastic’s global managed testing infrastructure or Private Locations as this is not supported.
</note>

<definitions>
  <definition term="-h, --help">
    Shows help for the `npx @elastic/synthetics` command.
  </definition>
</definitions>

<note>
  The `--pattern`, `--tags`, and `--match` flags for filtering are only supported when you run synthetic tests locally or push them to Elastic. Filtering is *not* supported in any other subcommands like `init` and `locations`.
</note>

<note>
  For debugging synthetic tests locally, you can set an environment variable, `DEBUG=synthetics npx @elastic/synthetics`, to capture Synthetics agent logs.
</note>


## `@elastic/synthetics init`

Scaffold a new Synthetics project using Elastic Synthetics.
This will create a template Node.js project that includes the synthetics agent, required dependencies, a synthetics configuration file, and example browser and lightweight monitor files. These files can be edited and then pushed to Elastic to create monitors.
```sh
npx @elastic/synthetics init <name-of-project>
```

Read more about what’s included in a template Synthetics project in [Create a Synthetics project](https://www.elastic.co/docs/solutions/observability/synthetics/create-monitors-with-projects).

## `@elastic/synthetics push`

Create monitors by using your local journeys. By default, running `push` command will use the `project` settings field from the `synthetics.config.ts` file, which is set up using the `init` command. However, you can override these settings using the CLI flags.
```sh
SYNTHETICS_API_KEY=<api-key> npx @elastic/synthetics push --url <kibana-url> --id <id|name>
```

<note>
  The `push` command includes interactive prompts to prevent you from accidentally deleting or duplicating monitors. You will see a prompt when:
  - You `push` a Synthetics project that used to contain one or more monitors but either no longer contains previously running monitors or has any monitors. Select `yes` to delete the monitors associated with the project ID being pushed.
  - You `push` a Synthetics project that’s already been pushed using one Synthetics project ID and then try to `push` it using a *different* ID. Select `yes` to create duplicates of all monitors in the project. You can set `DEBUG=synthetics` environment variable to capture the deleted monitors.
</note>

<note>
  If the journey contains external NPM packages other than the `@elastic/synthetics`, those packages will be bundled along with the journey code when the `push` command is invoked. However there are some limitations when using external packages:
  - Bundled journeys after compression should not be more than 1500 Kilobytes.
  - Native node modules will not work as expected due to platform inconsistency.
  - Uploading files in journey scripts(via locator.setInputFiles) is not supported.
</note>

<definitions>
  <definition term="--auth <string>">
    API key used for [authentication](https://www.elastic.co/docs/deploy-manage/api-keys/elasticsearch-api-keys). You can also set the API key via the `SYNTHETICS_API_KEY` environment variable.
    If you are pushing to a [Private Location](https://www.elastic.co/docs/solutions/observability/synthetics/create-monitors-ui), you must use an API key generated in 8.4 or higher.
    On Elastic Stack, you must be logged into Kibana as a user with the privileges described in [Writer role](https://www.elastic.co/docs/solutions/observability/synthetics/writer-role) to create an API key.
    On Elastic Observability Serverless, you must be logged in as a user with [Editor](https://www.elastic.co/docs/solutions/observability/synthetics/grant-access-to-secured-resources) access to create an API key.
  </definition>
  <definition term="--id <string>">
    A unique id associated with your project. It will be used for logically grouping monitors.
    If you used [`init` to create a project](#elastic-synthetics-init-command), this is the `<name-of-project>` you specified.
    This can also be set in the configuration file using [`project.id`](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-project). The value defined via the CLI will take precedence.
  </definition>
  <definition term="--url <string>">
    The URL for the deployment or Observability Serverless project to which you want to upload the monitors.
    This can also be set in the configuration file using [`project.url`](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-project). The value defined via the CLI will take precedence.
  </definition>
</definitions>

<definitions>
  <definition term="--space <string>">
    The identifier of the target [Kibana space](https://www.elastic.co/docs/deploy-manage/manage-spaces) for the pushed monitors. Spaces help you organize pushed monitors. Pushes to the "default" space if not specified.
    This can also be set in the configuration file using [`project.space`](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-project). The value defined via the CLI will take precedence.
  </definition>
  <definition term="--schedule <number>">
    The interval (in minutes) at which the monitor should run.
    This can also be set in the configuration file using [`monitor.schedule`](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-monitor). The value defined via the CLI will take precedence.
  </definition>
  <definition term="--locations Array<SyntheticsLocationsType>">
    Where to deploy the monitor. Monitors can be deployed in multiple locations so that you can detect differences in availability and response times across those locations.
    To list available locations, refer to [`@elastic/synthetics locations`](#elastic-synthetics-locations-command).
    This can also be set in the configuration file using [`monitor.locations` in the configuration file](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-monitor). The value defined via the CLI will take precedence.
  </definition>
  <definition term="--private-locations Array<string>">
    The [Private Locations](https://www.elastic.co/docs/solutions/observability/synthetics/monitor-resources-on-private-networks) to which the monitors will be deployed. These Private Locations refer to locations hosted and managed by you, whereas `locations` are hosted by Elastic. You can specify a Private Location using the location’s name.
    To list available Private Locations, refer to [`@elastic/synthetics locations`](#elastic-synthetics-locations-command).
    This can also be set in the configuration file using [`monitor.privateLocations` in the configuration file](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-monitor). The value defined via the CLI will take precedence.
  </definition>
  <definition term="--fields <string>">
    A list of key-value pairs that will be sent with each monitor event. The `fields` are appended to Elasticsearch documents as `labels`, and those labels are displayed in Kibana in the *Monitor details* panel in the [individual monitor’s *Overview* tab](/docs/solutions/observability/synthetics/analyze-data#synthetics-analyze-individual-monitors-overview).
    Example: `--fields '{ "foo": bar", "team": "synthetics" }'`
    This can also be set in the configuration file using [the `monitor.fields` option](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-monitor). The value defined via the CLI will take precedence.
  </definition>
  <definition term="--maintenance-windows Array<string>">
    A list of maintenance window IDs used to associate every monitor with one or more [maintenance windows](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/maintenance-windows). This argument accepts a variable number of values as shown in the example.
    Example: `--maintenance-windows "maintenance-window-ID-1" "maintenance-window-ID-2`
    This can also be set in the configuration file using [the `monitor.fields` option](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-monitor). The value defined via the CLI will take precedence.
  </definition>
  <definition term="--yes">
    The `push` command includes interactive prompts to prevent you from accidentally deleting or duplicating monitors. If running the CLI non-interactively, you can override these prompts using the `--yes` option. When the `--yes` option is passed to `push`:
    - If you `push` a Synthetics project that used to contain one or more monitors but no longer contains any monitors, all monitors associated with the Synthetics project ID being pushed will be deleted.
    - If you `push` a Synthetics project that’s already been pushed using one Synthetics project ID and then try to `push` it using a *different* ID, it will create duplicates of all monitors in the Synthetics project.
  </definition>
  <definition term="--proxy-uri">
    The proxy URL to be used when connecting to Kibana on your deployment or Observability Serverless project.
    This can also be set in the configuration file using [`proxy.uri` in the configuration file](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-proxy). The value defined via the CLI will take precedence.
  </definition>
  <definition term="--proxy-token">
    (Optional) The authentication token to be used when connecting to the proxy URL. Based on auth header format `Basic Asaaas==`
    This can also be set in the configuration file using [`proxy.token` in the configuration file](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-proxy). The value defined via the CLI will take precedence.
  </definition>
  <definition term="--proxy-ca">
    (Optional) Override the trusted CA certificates for the proxy connection.
    This can also be set in the configuration file using [`proxy.ca` in the configuration file](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-proxy). The value defined via the CLI will take precedence.
  </definition>
  <definition term="--proxy-no-verify">
    (Optional) Disable TLS verification for the proxy connection.
    This can also be set in the configuration file using [`proxy.noVerify` in the configuration file](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-proxy). The value defined via the CLI will take precedence.
  </definition>
</definitions>


## Tag monitors

Synthetics journeys can be tagged with one or more tags. Use tags to filter journeys when running tests locally or pushing them to Elastic.
To add tags to a single journey, add the `tags` parameter to the `journey` function or use the `monitor.use` method.
```js
import {journey, monitor} from "@elastic/synthetics";

journey({name: "example journey", tags: ["env:qa"] }, ({ page }) => {
  monitor.use({
    tags: ["env:qa"]
  })
  // Add steps here
});
```

For lightweight monitors, use the `tags` field in the yaml configuration file.
```yaml
name: example monitor
tags:
  - env:qa
```

To apply tags to all browser and lightweight monitors, configure using [the `monitor.tags`](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-monitor) field in the `synthetics.config.ts` file.

### Filter monitors

When running the `npx @elastic/synthetics push` command, you can filter the monitors that are pushed to Kibana using the following flags:
<definitions>
  <definition term="--tags Array<string>">
    Push monitors with the given tags that match the glob pattern.
  </definition>
  <definition term="--match <string>">
    Push monitors with a name or tags that match the glob pattern.
  </definition>
  <definition term="--pattern <string>">
    RegExp pattern to match the journey files in the current working directory. Defaults to `/*.journey.(ts|js)$/` for browser monitors and `/.(yml|yaml)$/` for lightweight monitors.
  </definition>
</definitions>

You can combine these techniques and push the monitors to different Kibana clusters/space based on the tags by using multiple configuration files.
```sh
npx @elastic/synthetics push --config synthetics.qa.config.ts --tags env:qa
npx @elastic/synthetics push --config synthetics.prod.config.ts --tags env:prod
```


## `@elastic/synthetics locations`

List all available locations for running synthetics monitors.
```sh
npx @elastic/synthetics locations --url <host> --auth <api-key>
```

Run `npx @elastic/synthetics locations` with no flags to list all the available global locations managed by Elastic for running synthetics monitors.
To list both locations on Elastic’s global managed infrastructure and Private Locations, include:
<definitions>
  <definition term="--url <string>">
    The URL for the Kibana deployment or Observability Serverless project from which to fetch all available public and Private Locations.
  </definition>
  <definition term="--auth <string>">
    API key used for [authentication](https://www.elastic.co/docs/deploy-manage/api-keys/elasticsearch-api-keys).
  </definition>
  <definition term="--proxy-uri">
    The proxy URL to be used when connecting to Kibana on your deployment or Observability Serverless project.
    This can also be set in the configuration file using [`proxy.uri` in the configuration file](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-proxy). The value defined via the CLI will take precedence.
  </definition>
  <definition term="--proxy-token">
    (Optional) The authentication token to be used when connecting to the proxy URL. Based on auth header format `Basic Asaaas==`
    This can also be set in the configuration file using [`proxy.token` in the configuration file](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-proxy). The value defined via the CLI will take precedence.
  </definition>
  <definition term="--proxy-ca">
    (Optional) Override the trusted CA certificates for the proxy connection.
    This can also be set in the configuration file using [`proxy.ca` in the configuration file](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-proxy). The value defined via the CLI will take precedence.
  </definition>
  <definition term="--proxy-no-verify">
    (Optional) Disable TLS verification for the proxy connection.
    This can also be set in the configuration file using [`proxy.noVerify` in the configuration file](/docs/solutions/observability/synthetics/configure-projects#synthetics-configuration-proxy). The value defined via the CLI will take precedence.
  </definition>
</definitions>

<note>
  If an administrator has disabled Elastic managed locations for the role you are assigned and you do *not* include `--url` and `--auth`, all global locations managed by Elastic will be listed. However, you will not be able to push to these locations with your API key and will see an error: *You don’t have permission to use Elastic managed global locations*. For more details, refer to the [troubleshooting docs](/docs/troubleshoot/observability/troubleshooting-synthetics#synthetics-troubleshooting-public-locations-disabled).
</note>


## `@elastic/synthetics totp <secret>`

Generate a Time-based One-Time Password (TOTP) for multifactor authentication (MFA) in Synthetics.
<applies-switch>
  <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
    ```sh
    npx @elastic/synthetics totp <secret>
    npx @elastic/synthetics totp <secret> --issuer <string> --label <string>
    ```
  </applies-item>

  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    ```sh
    npx @elastic/synthetics totp <secret> --issuer <issuer> --label <label>
    ```
  </applies-item>
</applies-switch>

<definitions>
  <definition term="secret">
    The encoded secret key used to generate the TOTP.
  </definition>
  <definition term="--issuer <string>">
    Name of the provider or service that is assocaited with the account.
  </definition>
  <definition term="--label <string>">
    Identifier for the account. Defaults to `SyntheticsTOTP`
  </definition>
</definitions>


## Air-gapped environments

When working in air-gapped environments, setup can become complex and require workarounds. One common issue is Node.js installations or containers not trusting custom certificates. To bypass certificate errors, prefix `npx` related commands with `NODE_TLS_REJECT_UNAUTHORIZED=0`. For example, `NODE_TLS_REJECT_UNAUTHORIZED=0 npx @elastic/synthetics init project-name`. This allows the command to bypass the certificate validations for all TLS connections.