﻿---
title: Streams
description: Streams provides a single, centralized UI within Kibana that streamlines common tasks like extracting fields, setting data retention, and routing data,...
url: https://www.elastic.co/docs/solutions/observability/streams/streams
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2, Preview in 9.1
---

# Streams
Streams provides a single, centralized UI within Kibana that streamlines common tasks like extracting fields, setting data retention, and routing data, so you don't need to use multiple applications or manually configure underlying Elasticsearch components.

## Classic versus wired streams

Streams can operate in two modes: wired and classic. Both manage data streams in Elasticsearch, but differ in configuration, inheritance, and field mapping.

### Classic streams

Classic streams work with existing Elasticsearch data streams. Use classic streams when you want the ease of extracting fields and configuring data retention while working with data that's already being ingested into Elasticsearch.
Classic streams:
- Are based on existing data streams, index templates, and component templates.
- Can follow the data retention policy set in the existing index template.
- Do not support hierarchical inheritance or cascading configuration updates.


### Wired streams

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
</applies-to>

Wired streams send data directly to a single endpoint, from which you can route data into child streams based on [partitioning](https://www.elastic.co/docs/solutions/observability/streams/management/partitioning) set up manually or with the help of AI suggestions.
Wired streams:
- Allow you to organize streams in a parent-child hierarchy.
- Let child streams automatically inherit mappings, lifecycle settings, and processors.
- Send configuration changes through the hierarchy to keep streams consistent.

For more information, refer to [sending data to wired streams](https://www.elastic.co/docs/solutions/observability/streams/wired-streams).

## Managed components

When you configure classic or wired streams through the Streams UI or [Streams API](#streams-api), Elasticsearch-level components like templates and pipelines are created for the stream. These components are considered *managed* and shouldn't be modified using Elasticsearch APIs. When managing a stream through the Streams UI or API, continue doing so whenever possible.
You can still edit non-managed ingest pipelines, templates, and other components, but avoid those marked as managed or any per-data-stream mappings and settings. This behavior is similar to how Elasticsearch handles components managed by integrations. Refer to the [**Advanced** tab](https://www.elastic.co/docs/solutions/observability/streams/management/advanced) to review managed components.

## Required permissions

Streams requires the following permissions:
<applies-switch>
  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    Streams requires these Elastic Cloud Serverless roles:
    - Admin: Ability to manage all Streams
    - Editor/Viewer: Limited access, cannot perform all actions
  </applies-item>

  <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
    To manage all streams, you need the following permissions:
    - **Cluster permissions**: `manage_index_templates`, `manage_ingest_pipelines`, `manage_pipeline`, `read_pipeline`
    - **Data stream level permissions**: `read`, `write`, `create`, `manage`, `monitor`, `manage_data_stream_lifecycle`, `read_failure_store`, `manage_failure_store`, `manage_ilm`.
    To view streams, you need the following permissions:
    - **Data stream level**: `read`, `view_index_metadata`, `monitor`
    For more information, refer to [Cluster privileges](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-cluster) and [Granting privileges for data streams and aliases](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/granting-privileges-for-data-streams-aliases)
  </applies-item>
</applies-switch>


## Manage Streams visibility

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3
</applies-to>

You can set Streams visibility on a space-by-space basis by defining users' access to specific spaces. Refer to [Define access to a space](/docs/deploy-manage/manage-spaces#spaces-control-user-access) for more information.
Space settings only affect visibility. Set permissions to manage and edit Streams at the Elasticsearch level. Refer to [Required permissions](#streams-required-permissions) for more information.
<note>
  Creating [significant events](https://www.elastic.co/docs/solutions/observability/streams/management/significant-events) requires access to the `default` space.
</note>


## Access Streams

Open Streams from the following places in Kibana:
- Select **Streams** from the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
- Open the data stream for a specific document from **Discover**. To do this, expand the details flyout for a document that's stored in a data stream, and select **Stream** or an action associated with the document's data stream. Streams then opens filtered to the selected data stream.


### Streams API

<applies-to>
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.1
</applies-to>

You can also access Streams features using the Streams API. Refer to the [Streams API documentation](https://www.elastic.co/docs/api/doc/kibana/group/endpoint-streams) for more information.

## Manage individual streams

Interact with and configure your streams in the following ways:
- [**Retention**](https://www.elastic.co/docs/solutions/observability/streams/management/retention): Manage how your stream retains data and get insight into data ingestion and storage size.
- [**Partitioning**](https://www.elastic.co/docs/solutions/observability/streams/management/partitioning): <applies-to>Elastic Stack: Preview since 9.2</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to> Route data into child streams.
- [**Processing**](https://www.elastic.co/docs/solutions/observability/streams/management/extract): Parse and extract information from documents into dedicated fields.
- [**Schema**](https://www.elastic.co/docs/solutions/observability/streams/management/schema): Manage field mappings.
- [**Data quality**](https://www.elastic.co/docs/solutions/observability/streams/management/data-quality): Get information about failed and degraded documents in your stream.
- [**Advanced**](https://www.elastic.co/docs/solutions/observability/streams/management/advanced): Review and manually modify underlying Elasticsearch components of your stream.