﻿---
title: Replace processor
description: The Replace processor replaces portions of a string field that match a regular expression with a replacement string. To use the Replace processor: Select...
url: https://www.elastic.co/docs/solutions/observability/streams/management/extract/replace
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3
---

# Replace processor
The **Replace** processor replaces portions of a string field that match a regular expression with a replacement string.
To use the **Replace** processor:
1. Select **Create** → **Create processor**.
2. Select **Replace** from the **Processor** menu.
3. Set the **Source Field** to the field that contains the string you want to replace.
4. Set the **Pattern** to the regular expression or text that you want to replace.
5. Set the **Replacement** to the value that will replace the portion of the string matching your pattern. Replacements can be text, an empty value, or a capture group reference.

This functionality uses the Elasticsearch [Gsub processor](https://www.elastic.co/docs/reference/enrich-processor/gsub-processor) internally, but you configure it in Streamlang. Streamlang doesn’t always have 1:1 parity with the ingest processor options and behavior. Refer to [Processor limitations and inconsistencies](/docs/solutions/observability/streams/management/extract#streams-processor-inconsistencies).