﻿---
title: Manual pipeline configuration
description: The Manual pipeline configuration lets you create a JSON-encoded array of ingest pipeline processors.This is helpful if you want to add more advanced...
url: https://www.elastic.co/docs/solutions/observability/streams/management/extract/manual-pipeline-configuration
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2, Preview in 9.1
---

# Manual pipeline configuration
<note>
  The **manual pipeline configuration** processor is only available on [classic streams](/docs/solutions/observability/streams/streams#streams-classic-vs-wired).
</note>

The **Manual pipeline configuration** lets you create a JSON-encoded array of ingest pipeline processors.This is helpful if you want to add more advanced processing that isn't currently available as part of the UI-based processors.
Refer to the following documentation for more on manually configuring processors:
- [Create readable and maintainable ingest pipelines](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/readable-maintainable-ingest-pipelines)
- [Error handling in ingest pipelines](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/error-handling)
- [Ingest processor reference](https://www.elastic.co/docs/reference/enrich-processor)

To manually create an array of ingest pipeline processors:
1. Select **Create** → **Create processor**.
2. Select **Manual pipeline configuration** from the **Processor** menu.
3. In **Ingest pipeline processors**, add JSON to manually configure ingest pipelines.

<note>
  Conditions defined in the processor JSON take precedence over conditions defined in **Optional fields**.
</note>