﻿---
title: Drop document processor
description: The Drop document processor prevents documents from being indexed when they meet a specific condition, without raising an error. To configure a condition...
url: https://www.elastic.co/docs/solutions/observability/streams/management/extract/drop
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3
---

# Drop document processor
The **Drop document** processor prevents documents from being indexed when they meet a specific condition, without raising an error.
To configure a condition for dropping documents:
1. Select **Create** → **Create processor**.
2. Select **Drop document** from the **Processor** menu.
3. Set the **Condition** for when you want to drop a document.

<warning>
  The default is the `always` condition. Not setting a specific condition results in every document that matches the drop condition getting dropped from indexing.
</warning>

This functionality uses the Elasticsearch [Drop processor](https://www.elastic.co/docs/reference/enrich-processor/drop-processor) internally, but you configure it in Streamlang. Streamlang doesn’t always have 1:1 parity with the ingest processor options and behavior. Refer to [Processor limitations and inconsistencies](/docs/solutions/observability/streams/management/extract#streams-processor-inconsistencies).