﻿---
title: Dissect processor
description: The Dissect processor parses structured log messages and extracts fields from them. It uses a set of delimiters to split the log message into fields instead...
url: https://www.elastic.co/docs/solutions/observability/streams/management/extract/dissect
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2, Preview in 9.1
---

# Dissect processor
The **Dissect** processor parses structured log messages and extracts fields from them. It uses a set of delimiters to split the log message into fields instead of predefined patterns to match the log messages.
Dissect is much faster than Grok, and is recommend for log messages that follow a consistent, structured format.
To parse a log message with a dissect processor:
1. Select **Create** → **Create processor**.
2. Select **Dissect** from the **Processor** menu.
3. Set the **Source Field** to the field you want to dissect.
4. Set the delimiters you want to use in the **Pattern** field. Refer to the [example pattern](#streams-dissect-example) for more information on setting delimiters.

This functionality uses the Elasticsearch [Dissect processor](https://www.elastic.co/docs/reference/enrich-processor/dissect-processor) internally, but you configure it in Streamlang. Streamlang doesn’t always have 1:1 parity with the ingest processor options and behavior. Refer to [Processor limitations and inconsistencies](/docs/solutions/observability/streams/management/extract#streams-processor-inconsistencies).

## Example dissect pattern

The following example shows the dissect pattern for an unstructured log message.
**Log message:**
```
2025-04-04T09:04:45+00:00 ERROR 160.200.87.105 127.79.135.127 21582
```

**Dissect Pattern:**
```
%{timestamp} %{log.level} %{source.ip} %{destination.ip} %{destination.port}
```


## Generate patterns

<note>
  This feature requires a [Generative AI connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/gen-ai-connectors).
</note>

Instead of writing the dissect patterns by hand, you can select **Generate Patterns** to have AI generate them for you.
Generated patterns work best on semi-structured data. For very custom logs with a lot of text, creating patterns manually generally creates more accurate results.
To add a generated dissect pattern:
1. Select **Create processor**.
2. Select **Dissect** from the **Processor** menu.
3. Select **Generate pattern**.
4. Select **Accept** to add a generated pattern to the list of patterns used by the processor.


### How does **Generate patterns** work?

Streams groups the samples from the **Data preview** table into categories of similar messages. For each category, Streams generates suggestions by sending samples to the LLM. Suggestions are then shown in the UI.
<warning>
  This can incur additional costs, depending on the LLM connector you are using. Typically a single iteration uses between 1000 and 5000 tokens depending on the number of identified categories and the length of the messages.
</warning>