﻿---
title: Date processor
description: The Date processor parses dates from fields, and then uses the date or timestamp as the timestamp for the document. To extract a timestamp field using...
url: https://www.elastic.co/docs/solutions/observability/streams/management/extract/date
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2, Preview in 9.1
---

# Date processor
The **Date** processor parses dates from fields, and then uses the date or timestamp as the timestamp for the document.
To extract a timestamp field using the date processor:
1. Select **Create** → **Create processor**.
2. Select **Date** from the **Processor** menu.
3. Set the **Source Field** to the field containing the timestamp.
4. Set the **Format** field to one of the accepted date formats (ISO8602, UNIX, UNIX_MS, or TAI64N) or use a Java time pattern. Refer to the [example formats](#streams-date-examples) for more information.

This functionality uses the Elasticsearch [Date processor](https://www.elastic.co/docs/reference/enrich-processor/date-processor) internally, but you configure it in Streamlang. Streamlang doesn’t always have 1:1 parity with the ingest processor options and behavior. Refer to [Processor limitations and inconsistencies](/docs/solutions/observability/streams/management/extract#streams-processor-inconsistencies).

## Example formats

The following list provides some common examples of date formats and how to parse them.
**Common formats**
```
2025-04-04T09:04:45+00:00 => ISO8601
1618886400 => UNIX
1618886400123 => UNIX_MS
4000000049c9f0ca => TAI64N
```

**Custom formats**
```
2023-10-15 => yyyy-MM-dd
15/10/2023 => dd/MM/yyyy
10-15-2023 => MM-dd-yyyy
2023-288 => yyyy-DDD
15 Oct 2023 => dd MMM yyyy
Sunday, October 15, 2023 => EEEE, MMMM dd, yyyy
2023-10-15T14:30:00Z => yyyy-MM-dd'T'HH:mm:ssX
2023-10-15 14:30:00 => yyyy-MM-dd HH:mm:ss
```


## Optional fields

You can set the following optional fields for the date processor in the **Advanced settings**:

| Field         | Description                                                                                                                                |
|---------------|--------------------------------------------------------------------------------------------------------------------------------------------|
| Target field  | The field that will hold the parsed date. Defaults to `@timestamp`.                                                                        |
| Timezone      | The timezone to use when parsing the date. Supports template snippets. Defaults to `UTC`.                                                  |
| Locale        | The locale to use when parsing the date, relevant when parsing month names or weekdays. Supports template snippets. Defaults to `ENGLISH`. |
| Output format | The format to use when writing the date to `target_field`. Must be a valid Java time pattern. Defaults to `yyyy-MM-dd'T'HH:mm:ss.SSSXXX`.  |