﻿---
title: Convert processor
description: The Convert processor converts a field to a different data type. For example, you could convert a string to an integer. To convert a field to a different...
url: https://www.elastic.co/docs/solutions/observability/streams/management/extract/convert
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3
---

# Convert processor
The **Convert** processor converts a field to a different data type. For example, you could convert a string to an integer.
To convert a field to a different data type:
1. Select **Create** → **Create processor**.
2. Select **Convert** from the **Processor** menu.
3. Set the **Source Field** to the field you want to convert.
4. (Optional) Set **Target field** to write the converted value to a different field.
5. Set **Type** to the output data type.

<note>
  If you add a **Convert** processor inside a condition group (a **WHERE** block), you must set a **Target field**.
</note>

This functionality uses the Elasticsearch [Convert processor](https://www.elastic.co/docs/reference/enrich-processor/convert-processor) internally, but you configure it in Streamlang. Streamlang doesn’t always have 1:1 parity with the ingest processor options and behavior. Refer to [Processor limitations and inconsistencies](/docs/solutions/observability/streams/management/extract#streams-processor-inconsistencies).