﻿---
title: Elastic Observability Serverless feature tiers
description: Elastic Observability Serverless projects are available in the following tiers, each with a carefully selected set of features to enable common observability...
url: https://www.elastic.co/docs/solutions/observability/observability-serverless-feature-tiers
products:
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
---

# Elastic Observability Serverless feature tiers
Elastic Observability Serverless projects are available in the following tiers, each with a carefully selected set of features to enable common observability operations:
- **Observability Logs Essentials**: Includes everything you need to store and analyze logs at scale.
- **Observability Complete**: Adds full-stack observability capabilities to monitor cloud-native and hybrid environments.

Refer to the [feature comparison table](#obs-subscription-features) for a more detailed comparison between the tiers.

## Feature tier pricing

For pricing information, refer to [Elastic Observability Serverless pricing](https://www.elastic.co/pricing/serverless-observability).

## Feature comparison

The following table compares features available in Observability Complete and Observability Logs Essentials:

| **Feature**                                                                                                                                                        | Observability Complete | Observability Logs Essentials |
|--------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|-------------------------------|
| **[Ad-hoc analytics](https://www.elastic.co/docs/explore-analyze/discover)**                                                                                       | ✅                      | ✅                             |
| **[Out-of-the-box dashboards](https://www.elastic.co/docs/explore-analyze/dashboards)**                                                                            | ✅                      | ✅                             |
| **[Custom dashboards](https://www.elastic.co/docs/explore-analyze/dashboards)**                                                                                    | ✅                      | ✅                             |
| **[Alerting and notifications](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/configure-stack-monitoring-alerts)**                              | ✅                      | ✅                             |
| **[Integrations](https://www.elastic.co/integrations/data-integrations?solution=observability)**                                                                   | ✅                      | ✅                             |
| **[Machine learning](https://www.elastic.co/docs/explore-analyze/machine-learning)**                                                                               | ✅                      | ❌                             |
| **[Rate and pattern analysis](https://www.elastic.co/docs/explore-analyze/machine-learning/machine-learning-in-kibana/xpack-ml-aiops)**                            | ✅                      | ❌                             |
| **[Service level objectives (SLO)](https://www.elastic.co/docs/solutions/observability/incident-management/service-level-objectives-slos)**                        | ✅                      | ❌                             |
| **[Infrastructure and hosts](https://www.elastic.co/docs/solutions/observability/infra-and-hosts)**                                                                | ✅                      | ❌                             |
| **[APM](https://www.elastic.co/docs/solutions/observability/apm)**                                                                                                 | ✅                      | ❌                             |
| **[AI Assistant](https://www.elastic.co/docs/solutions/observability/ai/observability-ai-assistant)** including Elastic Managed LLMs                               | ✅                      | ❌                             |
| <applies-to>Elastic Cloud Serverless: Preview</applies-to> **[Agent Builder](https://www.elastic.co/docs/solutions/observability/ai/agent-builder-observability)** | ✅                      | ❌                             |
| **[Custom knowledge bases](/docs/solutions/observability/ai/observability-ai-assistant#obs-ai-kb-ui)**                                                             | ✅                      | ❌                             |
| **[Synthetics testing and browser experience monitoring](https://www.elastic.co/docs/solutions/observability/synthetics)**                                         | ✅                      | ❌                             |


## Add data to a serverless project

From the main navigation menu, select **Add data**. Select what you want to monitor and how you want to monitor it, then follow the instructions for your system.
- **Logs Essentials**: For more on adding data to a Logs Essentials project, refer to [Get started with Logs Essentials](https://www.elastic.co/docs/solutions/observability/get-started/logs-essentials).
- **Observability Complete**: For more on adding data to a Observability Complete project, refer to [Get started with Elastic Observability](https://www.elastic.co/docs/solutions/observability/get-started).


## Upgrade from Observability Logs Essentials to Observability Complete

<warning>
  Upgrading from Observability Logs Essentials to Observability Complete is permanent and is not reversible.
</warning>

To access the additional features available in Observability Complete, upgrade your Observability project feature tier by completing the following steps:
1. From the [Elastic Cloud Console](https://cloud.elastic.co), select **Manage** next to the Observability Logs Essentials serverless project you want to upgrade.
2. Next to **Project features**, select **Edit**.
3. Select **Observability Complete**.
4. Select **Save** to complete the upgrade.