﻿---
title: Send any log file using Elastic Agent
description: This guide shows you how to manually configure a standalone Elastic Agent to send your log data to Elasticsearch using the elastic-agent.yml file. For...
url: https://www.elastic.co/docs/solutions/observability/logs/stream-any-log-file
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Send any log file using Elastic Agent
This guide shows you how to manually configure a standalone Elastic Agent to send your log data to Elasticsearch using the `elastic-agent.yml` file. For an Elastic Distribution of OpenTelemetry (EDOT) Collector equivalent, refer to [Send any log file using OTel Collector](https://www.elastic.co/docs/solutions/observability/logs/stream-any-log-file-using-edot-collector).
To get started quickly without manually configuring the Elastic Agent, you can use the **Monitor hosts with Elastic Agent** quickstart. Refer to the [quickstart documentation](https://www.elastic.co/docs/solutions/observability/get-started/quickstart-monitor-hosts-with-elastic-agent) for more information.
Continue with this guide for instructions on manual configuration.

## Prerequisites

<applies-switch>
  <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
    To follow the steps in this guide, you need an Elastic Stack deployment that includes:
    - Elasticsearch for storing and searching data
    - Kibana for visualizing and managing data
    - Kibana user with `All` privileges on Fleet and Integrations. Since many Integrations assets are shared across spaces, users need the Kibana privileges in all spaces.
    - Integrations Server (included by default in every Elastic Cloud Hosted deployment)
    To get started quickly, create an Elastic Cloud Hosted deployment and host it on AWS, GCP, or Azure. [Try it out for free](https://cloud.elastic.co/registration?page=docs&placement=docs-body).
  </applies-item>

  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    The **Admin** role or higher is required to onboard log data. To learn more, refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles).
  </applies-item>
</applies-switch>


## Install and configure the standalone Elastic Agent

Complete these steps to install and configure the standalone Elastic Agent and send your log data to Elasticsearch:
1. [Download and extract the Elastic Agent installation package.](#logs-stream-extract-agent)
2. [Install and start the Elastic Agent.](#logs-stream-install-agent)
3. [Configure the Elastic Agent.](#logs-stream-agent-config)


### Step 1: Download and extract the Elastic Agent installation package

On your host, download and extract the installation package that corresponds with your system:
<tab-set>
  <tab-item title="macOS">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-darwin-x86_64.tar.gz
    tar xzvf elastic-agent-9.3.0-darwin-x86_64.tar.gz
    ```
  </tab-item>

  <tab-item title="Linux">
    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-linux-x86_64.tar.gz
    tar xzvf elastic-agent-9.3.0-linux-x86_64.tar.gz
    ```
  </tab-item>

  <tab-item title="Windows">
    ```powershell
    # PowerShell 5.0+
    wget https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-windows-x86_64.zip -OutFile elastic-agent-9.3.0-windows-x86_64.zip
    Expand-Archive .\elastic-agent-9.3.0-windows-x86_64.zip
    ```
  </tab-item>

  <tab-item title="DEB">
    <tip>
      To simplify upgrading to future versions of Elastic Agent, use the tarball distribution instead of the RPM distribution.
      You can install Elastic Agent in an unprivileged mode that does not require root privileges.
    </tip>

    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-amd64.deb
    sudo dpkg -i elastic-agent-9.3.0-amd64.deb
    ```
  </tab-item>

  <tab-item title="RPM">
    <tip>
      To simplify upgrading to future versions of Elastic Agent, use the tarball distribution instead of the RPM distribution.
      You can install Elastic Agent in an unprivileged mode that does not require root privileges.
    </tip>

    ```shell
    curl -L -O https://artifacts.elastic.co/downloads/beats/elastic-agent/elastic-agent-9.3.0-x86_64.rpm
    sudo rpm -vi elastic-agent-9.3.0-x86_64.rpm
    ```
  </tab-item>
</tab-set>


### Step 2: Install and start the Elastic Agent

After downloading and extracting the installation package, you're ready to install the Elastic Agent. From the agent directory, run the install command that corresponds with your system:
<note>
  On macOS, Linux (tar package), and Windows, run the `install` command to install and start Elastic Agent as a managed service and start the service. The DEB and RPM packages include a service unit for Linux systems with systemd. For these systems, you must enable and start the service.
</note>

<tab-set>
  <tab-item title="macOS">
    <tip>
      You must run this command as the root user because some integrations require root privileges to collect sensitive data.
    </tip>

    ```shell
    sudo ./elastic-agent install
    ```
  </tab-item>

  <tab-item title="Linux">
    <tip>
      You must run this command as the root user because some integrations require root privileges to collect sensitive data.
    </tip>

    ```shell
    sudo ./elastic-agent install
    ```
  </tab-item>

  <tab-item title="Windows">
    Open a PowerShell prompt as an Administrator (right-click the PowerShell icon and select **Run As Administrator**).From the PowerShell prompt, change to the directory where you installed Elastic Agent, and run:
    ```shell
    .\elastic-agent.exe install
    ```
  </tab-item>

  <tab-item title="DEB">
    <tip>
      You must run this command as the root user because some integrations require root privileges to collect sensitive data.
    </tip>

    ```shell
    sudo systemctl enable elastic-agent 
    sudo systemctl start elastic-agent
    ```
  </tab-item>

  <tab-item title="RPM">
    <tip>
      You must run this command as the root user because some integrations require root privileges to collect sensitive data.
    </tip>

    ```shell
    sudo systemctl enable elastic-agent 
    sudo systemctl start elastic-agent
    ```
  </tab-item>
</tab-set>

During installation, you're prompted with some questions:
1. When asked if you want to install the agent as a service, enter `Y`.
2. When asked if you want to enroll the agent in Fleet, enter `n`.


### Step 3: Configure the Elastic Agent

With your agent installed, configure it by updating the `elastic-agent.yml` file.

#### Locate your configuration file

After installing the agent, you'll find the `elastic-agent.yml` in one of the following locations according to your system:
<tab-set>
  <tab-item title="macOS">
    Main Elastic Agent configuration file location:`/Library/Elastic/Agent/elastic-agent.yml`
  </tab-item>

  <tab-item title="Linux">
    Main Elastic Agent configuration file location:`/opt/Elastic/Agent/elastic-agent.yml`
  </tab-item>

  <tab-item title="Windows">
    Main Elastic Agent configuration file location:`C:\Program Files\Elastic\Agent\elastic-agent.yml`
  </tab-item>

  <tab-item title="DEB">
    Main Elastic Agent configuration file location:`/etc/elastic-agent/elastic-agent.yml`
  </tab-item>

  <tab-item title="RPM">
    Main Elastic Agent configuration file location:`/etc/elastic-agent/elastic-agent.yml`
  </tab-item>
</tab-set>


#### Update your configuration file

The following is an example of a standalone Elastic Agent configuration. To configure your Elastic Agent, replace the contents of the `elastic-agent.yml` file with this configuration:
```yaml
outputs:
  default:
    type: elasticsearch
    hosts: '<your-elasticsearch-endpoint>:<port>'
    api_key: 'your-api-key'
inputs:
  - id: your-log-id
    type: filestream
    streams:
      - id: your-log-stream-id
        data_stream:
          dataset: example
        paths:
          - /var/log/your-logs.log
```

Next, set the values for these fields:
- `hosts`: Copy the Elasticsearch endpoint from **Help menu (![help icon](https://www.elastic.co/docs/solutions/images/observability-help-icon.svg)) → Connection details**. For example, `https://my-deployment.es.us-central1.gcp.cloud.es.io:443`.
- `api-key`: Use an API key to grant the agent access to Elasticsearch. To create an API key for your agent, refer to the [Create API keys for standalone agents](/docs/reference/fleet/grant-access-to-elasticsearch#create-api-key-standalone-agent) documentation.
  <note>
  The API key format should be `<id>:<key>`. Make sure you selected **Beats** when you created your API key. Base64 encoded API keys are not currently supported in this configuration.
  </note>
- `inputs.id`: A unique identifier for your input.
- `type`: The type of input. For collecting logs, set this to `filestream`.
- `streams.id`: A unique identifier for your stream of log data.
- `data_stream.dataset`: The name for your dataset data stream. Name this data stream anything that signifies the source of the data. In this configuration, the dataset is set to `example`. The default value is `generic`.
- `paths`: The path to your log files. You can also use a pattern like `/var/log/your-logs.log*`.


#### Restart the Elastic Agent

After updating your configuration file, you need to restart the Elastic Agent:
First, stop the Elastic Agent and its related executables using the command that works with your system:
<tab-set>
  <tab-item title="macOS">
    ```shell
    sudo launchctl unload /Library/LaunchDaemons/co.elastic.elastic-agent.plist
    ```

    <note>
      Elastic Agent will restart automatically if the system is rebooted.
    </note>
  </tab-item>

  <tab-item title="Linux">
    ```shell
    sudo service elastic-agent stop
    ```

    <note>
      Elastic Agent will restart automatically if the system is rebooted.
    </note>
  </tab-item>

  <tab-item title="Windows">
    ```shell
    Stop-Service Elastic Agent
    ```
    If necessary, use Task Manager on Windows to stop Elastic Agent. This will kill the `elastic-agent` process and any sub-processes it created (such as Beats).
    <note>
      Elastic Agent will restart automatically if the system is rebooted.
    </note>
  </tab-item>

  <tab-item title="DEB">
    The DEB package includes a service unit for Linux systems with systemd. On these systems, you can manage Elastic Agent by using the usual systemd commands.Use `systemctl` to stop the agent:
    ```shell
    sudo systemctl stop elastic-agent
    ```
    Otherwise, use:
    ```shell
    sudo service elastic-agent stop
    ```

    <note>
      Elastic Agent will restart automatically if the system is rebooted.
    </note>
  </tab-item>

  <tab-item title="RPM">
    The RPM package includes a service unit for Linux systems with systemd. On these systems, you can manage Elastic Agent by using the usual systemd commands.Use `systemctl` to stop the agent:
    ```shell
    sudo systemctl stop elastic-agent
    ```
    Otherwise, use:
    ```shell
    sudo service elastic-agent stop
    ```

    <note>
      Elastic Agent will restart automatically if the system is rebooted.
    </note>
  </tab-item>
</tab-set>

Next, restart the Elastic Agent using the command that works with your system:
<tab-set>
  <tab-item title="macOS">
    ```shell
    sudo launchctl load /Library/LaunchDaemons/co.elastic.elastic-agent.plist
    ```
  </tab-item>

  <tab-item title="Linux">
    ```shell
    sudo service elastic-agent start
    ```
  </tab-item>

  <tab-item title="Windows">
    ```shell
    Start-Service Elastic Agent
    ```
  </tab-item>

  <tab-item title="DEB">
    The DEB package includes a service unit for Linux systems with systemd. On these systems, you can manage Elastic Agent by using the usual systemd commands.Use `systemctl` to start the agent:
    ```shell
    sudo systemctl start elastic-agent
    ```
    Otherwise, use:
    ```shell
    sudo service elastic-agent start
    ```
  </tab-item>

  <tab-item title="RPM">
    The RPM package includes a service unit for Linux systems with systemd. On these systems, you can manage Elastic Agent by using the usual systemd commands.Use `systemctl` to start the agent:
    ```shell
    sudo systemctl start elastic-agent
    ```
    Otherwise, use:
    ```shell
    sudo service elastic-agent start
    ```
  </tab-item>
</tab-set>


## Troubleshoot your Elastic Agent configuration

If you're not seeing your log files in the UI, verify the following in the `elastic-agent.yml` file:
- The path to your logs file under `paths` is correct.
- Your API key is in `<id>:<key>` format. If not, your API key may be in an unsupported format, and you'll need to create an API key in **Beats** format.

If you're still running into issues, see [Common problems with Fleet and Elastic Agent](https://www.elastic.co/docs/troubleshoot/ingest/fleet/common-problems) and [Configure standalone Elastic Agents](https://www.elastic.co/docs/reference/fleet/configure-standalone-elastic-agents).

## Next steps

After you have your agent configured and are streaming log data to Elasticsearch:
- Refer to the [Explore log data](https://www.elastic.co/docs/solutions/observability/logs/discover-logs) documentation for information on exploring your log data in the UI, including searching and filtering your log data, getting information about the structure of log fields, and displaying your findings in a visualization.
- Refer to the [Parse and organize logs](https://www.elastic.co/docs/solutions/observability/logs/parse-route-logs) documentation for information on extracting structured fields from your log data, rerouting your logs to different data streams, and filtering and aggregating your log data.
- Refer to the [Filter and aggregate logs](https://www.elastic.co/docs/solutions/observability/logs/filter-aggregate-logs) documentation for information on filtering and aggregating your log data to find specific information, gain insight, and monitor your systems more efficiently.