﻿---
title: Configure log data sources
description: The observability:logSources Kibana advanced setting defines which index patterns your deployment or project uses to store and query log data. Configure...
url: https://www.elastic.co/docs/solutions/observability/logs/log-data-sources
products:
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Configure log data sources
The `observability:logSources` Kibana advanced setting defines which index patterns your deployment or project uses to store and query log data.
Configure this setting from the **Advanced Settings** page, which you can open from the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
<note>
  Adding indices to the `observability:logSources` setting that don't contain log data may cause degraded functionality. Changes to this setting can also impact the sources queried by log threshold rules.
</note>


## Configure log data sources using the `saved_objects` API

<important>
  Using the `saved_objects` API to import log data sources has the following limitations:
  - To import the log data source, you need to import the entire **Advanced Settings** saved object. This overwrites any other changes that you've made to your **Advanced Settings** in the target cluster, not just `observability:logSources`.
  - This approach is backward compatible, but not forward compatible. You cannot import the settings from an older version to a newer version.
</important>

To configure log data sources using the `saved_objects` API and the **Advanced Settings** saved object:
1. Go to **Advanced Settings** from the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Configure your custom log sources in `observability:logSources`.
3. Go to the **Saved Objects** management page from the navigation or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
4. [Export](/docs/explore-analyze/find-and-organize/saved-objects#saved-objects-import-and-export) the **Advanced Settings** saved object.
5. Import the saved object to your target cluster using the [import saved objects API](https://www.elastic.co/docs/api/doc/kibana//operation/operation-importsavedobjectsdefault).