﻿---
title: Explore logs in Discover
description: From the logs-* or All logs data view in Discover, you can quickly search and filter your log data, get information about the structure of log fields,...
url: https://www.elastic.co/docs/solutions/observability/logs/discover-logs
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Explore logs in Discover
From the `logs-*` or `All logs` data view in Discover, you can quickly search and filter your log data, get information about the structure of log fields, and display your findings in a visualization. You can also customize and save your searches and place them on a dashboard. Instead of having to log into different servers, change directories, and view individual files, all your logs are available in a single view.
To open **Discover**, find `Discover` in the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). Select the `logs-*` or `All logs` data view from the **Data view** menu.
<note>
  For a contextual logs experience, set the **Solution view** for your space to **Observability**. Refer to [Managing spaces](https://www.elastic.co/docs/deploy-manage/manage-spaces) for more information.
</note>

![Screen capture of Discover](https://www.elastic.co/docs/solutions/images/observability-log-explorer.png)


## Required Kibana privileges

Viewing data in Discover logs data views requires `read` privileges for **Discover**, **Index**, and **Logs**. For more on assigning Kibana privileges, refer to the [Kibana privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges) docs.

## Find your logs

By default, the **All logs** data view shows all of your logs, according to the index patterns set in the **logs sources** advanced setting. To open **Advanced settings**, find it in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
To focus on logs from a specific source or sources, create a data view using the index patterns of those source. For more information on creating data views, refer to [Create a data view](/docs/explore-analyze/find-and-organize/data-views#settings-create-pattern)
Once you have the logs you want to focus on displayed, you can drill down further to find the information you need. For more on filtering your data in Discover, refer to [Filter logs in Discover](/docs/solutions/observability/logs/filter-aggregate-logs#logs-filter-discover).

## Review log data in the documents table

The documents table lets you add fields, order table columns, sort fields, and update the row height in the same way you would in Discover.
Refer to the [Discover](https://www.elastic.co/docs/explore-analyze/discover) documentation for more information on updating the table.

### Actions column

The actions column provides additional information about your logs.
**Expand:** ![The icon to expand log details](https://www.elastic.co/docs/solutions/images/observability-expand-icon.png) Open the log details to get an in-depth look at an individual log file.
**Degraded document indicator:** ![The icon that shows ignored fields](https://www.elastic.co/docs/solutions/images/observability-pagesSelect-icon.png) This indicator shows if any of the document’s fields were ignored when it was indexed. Ignored fields could indicate malformed fields or other issues with your document. Use this information to investigate and determine why fields are being ignored.
**Stacktrace indicator:** ![The icon that shows if a document contains stack traces](https://www.elastic.co/docs/solutions/images/observability-apmTrace-icon.png) This indicator makes it easier to find documents that contain additional information in the form of stacktraces.

## View log details

Click the expand icon ![icon to open log details](https://www.elastic.co/docs/solutions/images/observability-expand-icon.png) to get an in-depth look at an individual log file.
These details provide immediate feedback and context for what’s happening and where it’s happening for each log. From here, you can quickly debug errors and investigate the services where errors have occurred.
The following actions help you filter and focus on specific fields in the log details:
- **Filter for value (![filter for value icon](https://www.elastic.co/docs/solutions/images/observability-plusInCircle.png)):** Show logs that contain the specific field value.
- **Filter out value (![filter out value icon](https://www.elastic.co/docs/solutions/images/observability-minusInCircle.png)):** Show logs that do **not** contain the specific field value.
- **Filter for field present (![filter for present icon](https://www.elastic.co/docs/solutions/images/observability-filter.png)):** Show logs that contain the specific field.
- **Toggle column in table (![toggle column in table icon](https://www.elastic.co/docs/solutions/images/observability-listAdd.png)):** Add or remove a column for the field to the main Discover table.


## View log data set details

Go to **Data Sets** to view more details about your data sets and monitor their overall quality. To open the **Data Set Quality** management page, find it in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
Refer to [Data set quality](https://www.elastic.co/docs/solutions/observability/data-set-quality-monitoring) for more information.