﻿---
title: Add a service name to logs
description: Adding the service.name field to your logs associates them with the services that generate them. You can use this field to view and manage logs for distributed...
url: https://www.elastic.co/docs/solutions/observability/logs/add-service-name-to-logs
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Add a service name to logs
Adding the `service.name` field to your logs associates them with the services that generate them. You can use this field to view and manage logs for distributed services located on multiple hosts.
To add a service name to your logs, either:
- Use the `add_fields` processor through an integration, Elastic Agent configuration, or Filebeat configuration.
- Map an existing field from your data stream to the `service.name` field.


## Use the add fields processor to add a service name

For log data without a service name, use the [`add_fields` processor](https://www.elastic.co/docs/reference/fleet/add_fields-processor) to add the `service.name` field. You can add the processor in an integration’s settings or in the Elastic Agent or Filebeat configuration.
For example, adding the `add_fields` processor to the inputs section of a standalone Elastic Agent or Filebeat configuration would add `your_service_name` as the `service.name` field:
```json
processors:
    - add_fields:
        target: service
        fields:
            name: your_service_name
```

Adding the `add_fields` processor to an integration’s settings would add `your_service_name` as the `service.name` field:
![Add the add_fields processor to an integration](https://www.elastic.co/docs/solutions/images/serverless-add-field-processor.png)

For more on defining processors, refer to [define processors](https://www.elastic.co/docs/reference/fleet/agent-processors).

## Map an existing field to the service name field

For logs that with an existing field being used to represent the service name, map that field to the `service.name` field using the [alias field type](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/field-alias). Follow these steps to update your mapping:
1. Find the **Index Management** page in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Select **Index Templates**.
3. Search for the index template you want to update.
4. From the **Actions** menu for that template, select **edit**.
5. Go to **Mappings**, and select **Add field**.
6. Under **Field type**, select **Alias** and add `service.name` to the **Field name**.
7. Under **Field path**, select the existing field you want to map to the service name.
8. Select **Add field**.

For more ways to add a field to your mapping, refer to [add a field to an existing mapping](/docs/manage-data/data-store/mapping/explicit-mapping#add-field-mapping).

## Additional ways to process data

The Elastic Stack provides additional ways to process your data:
- **[Ingest pipelines](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines):** convert data to ECS, normalize field data, or enrich incoming data.
- **[Logstash](https://www.elastic.co/docs/reference/logstash):** enrich your data using input, output, and filter plugins.