﻿---
title: Use a proxy with the Universal Profiling Agent
description: In some cases, your infrastructure Universal Profiling Agent installation needs to use an HTTP proxy to reach Elastic Cloud. In these cases, you can use...
url: https://www.elastic.co/docs/solutions/observability/infra-and-hosts/use-proxy-with-universal-profiling-agent
products:
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# Use a proxy with the Universal Profiling Agent
In some cases, your infrastructure Universal Profiling Agent installation needs to use an HTTP proxy to reach Elastic Cloud. In these cases, you can use the `HTTPS_PROXY` environment variable to configure a proxy used by the Universal Profiling Agent. The connection to the backend (Elastic Cloud) will be tunneled through the proxy (no MITM-TLS) using the CONNECT method. Basic authentication is supported. This can be useful in environments with security policies or network restrictions that block direct connections to outside hosts.
<important>
  You need to set the `HTTPS_PROXY` environment variable in the machines that will run the Universal Profiling Agents. If you set the environment variable after the Universal Profiling Agent is installed, you may need to reinstall the Universal Profiling Agent.
</important>

The following example shows how to use the `HTTPS_PROXY` environment variable:
```bash
export HTTPS_PROXY=http://username:password@proxy:port
```