﻿---
title: Step 2: Enable Universal Profiling in Kibana
description: Configure Kibana to enable the Universal Profiling plugin with the following configuration: Refer to the steps for your platform to deploy update the...
url: https://www.elastic.co/docs/solutions/observability/infra-and-hosts/step-2-enable-universal-profiling-in-kibana
products:
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# Step 2: Enable Universal Profiling in Kibana
Configure Kibana to enable the Universal Profiling plugin with the following configuration:
```yaml
xpack.profiling.enabled: true
```

Refer to the steps for your platform to deploy update the configuration.

## ECE

Install the 8.12.0 stackpack or higher. Refer to [ECE manage elastic stack](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/manage-elastic-stack-versions) for more information.
In ECE, you don’t need to perform any additional steps to enable the Universal Profiling plugin in Kibana.

## Self-managed Elastic stack

1. Edit the Kibana YAML configuration file, usually named [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) by adding previous configuration line.
2. Restart Kibana to reload the configuration.


## Kubernetes

If you’re using ECK, add the previous configuration line to the `kibana.k8s.elastic.co/v1` CRD, placing it under the `spec.config` key. Refer to the [ECK documentation](/docs/deploy-manage/deploy/cloud-on-k8s/k8s-kibana-advanced-configuration#k8s-kibana-configuration) for more on configuring Kibana.
If you’re not using ECK, edit the `secret` or `configMap` holding the [`kibana.yml`](https://www.elastic.co/docs/deploy-manage/stack-settings) configuration file. Add the previously mentioned config line, and then perform a rolling restart of the Kibana deployment to reload the configuration.
Continue to [Step 3: Set up Universal Profiling in Kibana](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/step-3-set-up-universal-profiling-in-kibana).