﻿---
title: Step 1: Update the stack
description: To install the Universal Profiling backend, you need to be running the minimum supported version of the Elastic stack. Refer to the following instructions...
url: https://www.elastic.co/docs/solutions/observability/infra-and-hosts/step-1-update-stack
products:
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# Step 1: Update the stack
To install the Universal Profiling backend, you need to be running the minimum supported version of the Elastic stack. Refer to the following instructions to update the stack on your platform:
- [ECE](#profiling-self-managed-updating-ece)
- [Self-managed Elastic stack](#profiling-self-managed-updating-self-managed)
- [Kubernetes](#profiling-self-managed-updating-k8s)


## ECE

Update ECE to version 3.7.0 or higher, following the [installations instructions](https://www.elastic.co/downloads/enterprise).

## Self-managed Elastic stack

<warning>
  We don’t currently support running the backend applications through Elastic Agent.
</warning>

1. Deploy a minimum version 8.12.0 of the Elastic stack (Elasticsearch, Kibana).
2. Ensure the machines hosting the Universal Profiling backend run a Linux kernel version 4.x or higher.


## Kubernetes

We don’t currently support running the *backend* applications through ECK, but, if you’re running an Elastic stack through ECK, you can still connect the Universal Profiling backend applications to it.
1. Update the ECK deployment you want to enable Universal Profiling to 8.12.0 or higher.
2. If you’re not using ECK, ensure your deployments of Elasticsearch and Kibana are configured to use the minimum supported version (8.12.0 or higher).

Continue to [Step 2: Enable Universal Profiling in Kibana](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/step-2-enable-universal-profiling-in-kibana).