﻿---
title: Configure infrastructure and host metrics settings
description: From the navigation menu, go to Infrastructure → Infrastructure inventory or Hosts, and click the Settings link at the top of the page. The following...
url: https://www.elastic.co/docs/solutions/observability/infra-and-hosts/configure-settings
products:
  - Elastic Cloud Serverless
  - Elastic Observability
---

# Configure infrastructure and host metrics settings
<note>
  The **Editor** role or higher is required to configure settings. To learn more, refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles).
</note>

From the navigation menu, go to **Infrastructure** → **Infrastructure inventory** or **Hosts**, and click the **Settings** link at the top of the page. The following settings are available:

| Setting              | Description                                                                                                                            |
|----------------------|----------------------------------------------------------------------------------------------------------------------------------------|
| **Name**             | Name of the source configuration.                                                                                                      |
| **Indices**          | Index pattern or patterns used to match Elasticsearch indices that contain metrics. The default patterns are `metrics-*,metricbeat-*`. |
| **Machine Learning** | The minimum severity score required to display anomalies in the Infrastructure UI. The default is 50.                                  |
| **Features**         | Turn new features on and off.                                                                                                          |

Click **Apply** to save your changes.
<note>
  The patterns used to match log sources are configured in Kibana advanced settings. The default setting is `logs-*-*,logs-*,filebeat-*`. To change the default, go to **Log sources** [advanced setting](https://www.elastic.co/docs/reference/kibana/advanced-settings#kibana-search-settings).
</note>

If the fields are grayed out and cannot be edited, you may not have sufficient privileges to change the source configuration.
<tip>
  If [Spaces](https://www.elastic.co/docs/deploy-manage/manage-spaces) are enabled in your Kibana instance, any configuration changes you make here are specific to the current space. You can make different subsets of data available by creating multiple spaces with different data source configurations.
</tip>