﻿---
title: Collect NGINX data with OpenTelemetry integrations (Fleet-managed)
description: Collect NGINX logs and metrics with a Fleet-managed Elastic Agent using Elastic's Nginx integration and NGINX OpenTelemetry Input Package.
url: https://www.elastic.co/docs/solutions/observability/infra-and-hosts/collect-nginx-data-otel-integration-fleet-managed
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.2
---

# Collect NGINX data with OpenTelemetry integrations (Fleet-managed)
Learn how to monitor your NGINX server by collecting logs and metrics with a Fleet-managed Elastic Agent on Linux.
You'll use Kibana and Fleet to create an [agent policy that combines both ECS-based integrations and OpenTelemetry input packages](/docs/reference/fleet/otel-integrations#otel-integrations-hybrid-policies) and apply it to your Fleet-managed Elastic Agent.
You'll collect:
- NGINX logs with Elastic's [Nginx integration](https://www.elastic.co/docs/reference/integrations/nginx), based on the [Elastic Common Schema](https://www.elastic.co/docs/reference/ecs) (ECS)
- NGINX metrics with Elastic's [NGINX OpenTelemetry Input Package](https://www.elastic.co/docs/reference/integrations/nginx_otel_input), which uses the [`nginxreceiver`](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/nginxreceiver) OpenTelemetry (OTel) Collector receiver

<important>
  OpenTelemetry input packages are used with Fleet and Elastic Agent running in default mode. They cannot be used with an [Elastic Agent running as an EDOT Collector](https://www.elastic.co/docs/reference/fleet/otel-agent) (an agent in `otel` mode).
</important>


## Prerequisites

<applies-switch>
  <applies-item title="serverless: preview" applies-to="Elastic Cloud Serverless: Preview">
    - An Observability project. To learn more, refer to [Create an Observability project](https://www.elastic.co/docs/solutions/observability/get-started).
    - A user with the **Admin** role. To learn more, refer to [User roles and privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles).
    - Elastic Agent 9.2 or later installed on a Linux host.
    - NGINX installed on the Linux host.
  </applies-item>

  <applies-item title="stack: preview 9.2+" applies-to="Elastic Stack: Preview since 9.2">
    - An Elasticsearch cluster for storing and searching your data, and Kibana for visualizing and managing your data.
    - A user with the **Admin** role. To learn more, refer to [User roles and privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles).
    - Elastic Agent 9.2 or later installed on a Linux host.
    - NGINX installed on the Linux host.
  </applies-item>
</applies-switch>


## Configure the NGINX status endpoint

The [`nginxreceiver`](https://github.com/open-telemetry/opentelemetry-collector-contrib/tree/main/receiver/nginxreceiver) OTel Collector receiver needs an endpoint that exposes NGINX status metrics.
1. Make sure the [`ngx_http_stub_status_module`](https://nginx.org/en/docs/http/ngx_http_stub_status_module.html) module is enabled.
2. In your NGINX configuration file (for example, `/etc/nginx/nginx.conf`), add or modify the `location` block in the `server { ... }` block with the following:
   ```nginx
   location = /status {
     stub_status;
   }
   ```
3. Save the configuration and restart NGINX:
   ```bash
   sudo systemctl restart nginx
   ```
4. Verify that the endpoint is active:
   ```bash
   curl http://localhost:80/status 
   ```
   1. Use the port number specified in the `listen` directive in the NGINX configuration.
   If the endpoint returns data, you are ready to set up Elastic Agent.

For more details, refer to [Configuring NGINX for Metric Collection](https://docs.nginx.com/nginx-amplify/nginx-amplify-agent/configuring-metric-collection/#metrics-from-stub_status).

## Configure the agent policy

<stepper>
  <step title="Create an agent policy and enroll an agent">
    1. In Kibana, find **Fleet** in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. Go to **Agent policies**, then [create an agent policy](/docs/reference/fleet/agent-policy#create-a-policy) (for example, `nginx-telemetry`), or select an existing policy you want to use to collect NGINX telemetry.
    3. Add an Elastic Agent running version 9.2 or later to the policy.
       For detailed steps, refer to [Install Fleet-managed Elastic Agents](https://www.elastic.co/docs/reference/fleet/install-fleet-managed-elastic-agent).
  </step>

  <step title="Configure log collection with the Nginx integration">
    1. In Kibana, find **Integrations** in the navigation menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. Search for "nginx", then select the **Nginx** integration.
    3. Select **Add Nginx**, then configure the integration. Log collection from NGINX instances is enabled by default.
       1. Confirm the **Paths** fields for access and error logs match your NGINX configuration.
    2. Turn off **Collect metrics from Nginx instances**. In this tutorial, you’ll use the OpenTelemetry input package for metrics collection.
    4. In the **Where to add this integration?** section, select **Existing hosts**.
    5. Select the agent policy to which you want to add the integration (for example, `nginx-telemetry`).
    6. Select **Save and continue**.
    For more details, refer to [Add an integration to an Elastic Agent policy](https://www.elastic.co/docs/reference/fleet/add-integration-to-policy).
  </step>

  <step title="Configure metrics collection with the NGINX OpenTelemetry input package">
    1. In Kibana, go to **Integrations**.
    2. Select **Display beta integrations** (the NGINX OpenTelemetry packages are in technical preview).
    3. Search for "nginx", then select **NGINX OpenTelemetry Input Package**.
    4. Select **Add NGINX OpenTelemetry Input Package**, then configure the integration. **NGINX OpenTelemetry Input** is enabled by default.
       1. Select **Change defaults**, then expand **Advanced options**.
    2. Set the data stream type to **Metrics**.
    3. Set **endpoint** to your NGINX `stub_status` URL (for example, `http://localhost:80/status`).
    5. In the **Where to add this integration?** section, select **Existing hosts**.
    6. Select the agent policy you used for the NGINX log collection (for example, `nginx-telemetry`).
    7. Select **Save and continue**.

    <note>
      The NGINX OpenTelemetry Assets content package is installed automatically when data is ingested through the NGINX OpenTelemetry Input Package. You can find it in the **Installed integrations** list and use it to visualize OTel-based metrics.
    </note>
  </step>
</stepper>


## Validate your data

After you apply the policy changes, validate that both the ECS-based logs and the OTel-based metrics are flowing in.
<stepper>
  <step title="Validate the log collection">
    1. In Kibana, go to **Discover**, then filter the results using the KQL search bar.
    2. Search for NGINX data stream datasets such as `nginx.access` and `nginx.error`, or enter:
       ```text
       data_stream.dataset : "nginx.access" or "nginx.error"
       ```
    3. Go to **Dashboards**, then select **[Logs Nginx] Access and error logs** to view the dashboard installed by the Nginx integration.
  </step>

  <step title="Validate the metrics collection">
    Go to **Dashboards**, then select **[Metrics Nginx OTEL] Overview** to view the dashboard for visualizing OTel-based metrics.This dashboard is provided by the NGINX OpenTelemetry Assets content package, installed automatically when data is ingested through the NGINX OpenTelemetry Input Package.
  </step>
</stepper>


## Related pages

- [Collect OpenTelemetry data with Elastic Agent integrations](https://www.elastic.co/docs/reference/fleet/otel-integrations)
- [Collect NGINX data with OpenTelemetry integrations (standalone)](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/collect-nginx-data-otel-integration-standalone)
- [Elastic integrations](https://www.elastic.co/docs/reference/integrations)