﻿---
title: Analyze infrastructure and host metrics
description: Observability allows you to visualize infrastructure metrics to help diagnose problematic spikes, identify high resource utilization, automatically discover...
url: https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Analyze infrastructure and host metrics
Observability allows you to visualize infrastructure metrics to help diagnose problematic spikes, identify high resource utilization, automatically discover and track pods, and unify your metrics with logs and APM data.
<tip>
  We recommend using the [Elastic Distribution of OpenTelemetry (EDOT) Collector](https://www.elastic.co/docs/solutions/observability/get-started/quickstart-monitor-hosts-with-opentelemetry) to collect infrastructure metrics. You can also use Elastic Agent integrations to ingest and analyze metrics from servers, Docker containers, Kubernetes deployments, and more.
</tip>

For more information, refer to the following links:
- [Get started with system metrics](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/get-started-with-system-metrics): Learn how to onboard your system metrics data quickly.
- [View infrastructure metrics by resource type](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/view-infrastructure-metrics-by-resource-type): Use the **Inventory page** to get a metrics-driven view of your infrastructure grouped by resource type.
- [Analyze and compare hosts](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-compare-hosts): Use the **Hosts** page to get a metrics-driven view of your infrastructure backed by an easy-to-use interface called Lens.
- [Detect metric anomalies](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/detect-metric-anomalies): Detect and inspect memory usage and network traffic anomalies for hosts and Kubernetes pods.
- [Configure infrastructure and host metrics settings](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/configure-settings): Learn how to configure infrastructure UI settings.
- [Metrics reference](https://www.elastic.co/docs/reference/observability/metrics-reference): Learn about key metrics used for infrastructure monitoring.
- [Infrastructure app fields](https://www.elastic.co/docs/reference/observability/fields-and-object-schemas): Learn about the fields required to display data in the Infrastructure UI.

By default, the Infrastructure UI displays metrics from Elasticsearch indices that match the `metrics-*` and `metricbeat-*` index patterns. To learn how to change this behavior, refer to [Configure settings](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/configure-settings).