﻿---
title: Infrastructure and host monitoring
description: Explore the topics in this section to learn how to observe and monitor hosts and other systems running in your environment. 
url: https://www.elastic.co/docs/solutions/observability/infra-and-hosts
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Infrastructure and host monitoring
Explore the topics in this section to learn how to observe and monitor hosts and other systems running in your environment.
<tip>
  We recommend using the [Elastic Distribution of OpenTelemetry (EDOT) Collector](https://www.elastic.co/docs/solutions/observability/get-started/quickstart-monitor-hosts-with-opentelemetry) to collect infrastructure metrics and logs. You can also use the [Elastic Agent](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/get-started-with-system-metrics) with integrations for infrastructure monitoring.
</tip>


|                                                                                                                                                              |                                                                                                                                                                                                        |
|--------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [Analyze infrastructure and host metrics](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics)           | Visualize infrastructure metrics to help diagnose problematic spikes, identify high resource utilization, automatically discover and track pods, and unify your metrics with other observability data. |
| [Universal Profiling](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/universal-profiling)                                               | Profile all the code running on a machine, including application code, kernel, and third-party libraries.                                                                                              |
| [Tutorial: Observe your Kubernetes deployments](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/tutorial-observe-kubernetes-deployments) | Observe all layers of your application, including the orchestration software itself.                                                                                                                   |
| [Tutorial: Observe your nginx instances](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/tutorial-observe-nginx-instances)               | Collect valuable metrics and logs from your nginx instances.                                                                                                                                           |
| [Troubleshooting](https://www.elastic.co/docs/troubleshoot/observability/troubleshooting-infrastructure-monitoring)                                          | Troubleshoot common issues on your own or ask for help.                                                                                                                                                |
| [Metrics reference](https://www.elastic.co/docs/reference/observability/metrics-reference)                                                                   | Learn about the key metrics displayed in the Infrastructure UI and how they are calculated.                                                                                                            |