﻿---
title: View and manage SLOs in Elastic Observability
description: Manage your service level objectives (SLOs) from the SLO Management page. View SLO definitions, monitor the health of your SLOs, and perform actions such...
url: https://www.elastic.co/docs/solutions/observability/incident-management/slo-management
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.1
---

# View and manage SLOs in Elastic Observability
Manage your service level objectives (SLOs) from the **SLO Management** page. View SLO definitions, monitor the health of your SLOs, and perform actions such as purging data, checking SLO health, and deleting SLOs.
![Screenshot of the SLO Management user interface](https://www.elastic.co/docs/solutions/images/observability-slo-management.png)

To open the **SLO Management** page:
1. Navigate to the **SLOs** page in the main menu, or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Select **Manage SLOs**.


## Permissions

Actions like deleting SLOs and purging SLO data require [a role with edit privileges for SLOs](https://www.elastic.co/docs/solutions/observability/incident-management/configure-service-level-objective-slo-access). Users with [read-only privileges](https://www.elastic.co/docs/solutions/observability/incident-management/configure-service-level-objective-slo-access) can use the **SLO Management** page to find unhealthy SLOs that need attention.

## Filter SLOs

From the **SLO Management** page, use the search bar to find SLOs by name. Use the **Filter tags** menu to include or exclude SLOs from the view based on the defined tags.

## Monitor SLO health

<applies-to>
  - Elastic Stack: Generally available since 9.3
</applies-to>

The **Health** column of the SLO management table shows the following:
- **Healthy**: the SLO transforms are operating as expected.
- **Needs attention**: the SLO transforms are not operating as expected and need attention.

Select **Needs attention** to inspect the transforms with issues.
For more on SLO transforms and troubleshooting SLO health, refer to [Understanding SLO internals](/docs/troubleshoot/observability/troubleshoot-service-level-objectives-slos#slo-understanding-slos).

## Bulk delete SLOs

Use the **SLO Managment** page to delete multiple SLOs at once. To bulk delete SLOs:
1. From the **SLO Management** page, select the checkbox next to the SLOs you want to delete.
2. From the **Selected [number] SLO** menu, select **Delete**.
3. Select **Delete**.


## Purge stale SLO instances

<applies-to>
  - Elastic Stack: Generally available since 9.3
</applies-to>

A stale SLO instance hasn't received new data within the **Stale SLOs threshold** period, which you can set in the SLOs **Settings** page.
From the **Overview** on the **SLOs** page, you can see the number of **Stale** SLOs. Select the number to show your stale SLOs.
Occasionally, you might want to delete these stale instances. You can either purge all stale SLO instances at once or select SLOs from which to purge stale instances.

### Purge all stale SLO instances

To purge all stale SLO instances:
1. From the **SLO Management** page, select **Actions** → **Purge stale instances**.
2. If you don't want to delete stale instances according to the predefined **Stale SLOs threshold** setting, you can update the **Stale threshold**.
3. Select **Purge**.


### Purge stale instances from selected SLOs

To purge stale instances from individual or multiple SLOs:
1. From the **SLO Management** page, select the checkbox next to the SLOs from which you want to purge stale instances.
2. From the **Selected [number] SLOs** menu, select **Purge stale instances**.
3. If you don't want to delete stale instances according to the predefined **Stale SLOs threshold** setting, you can update the **Stale threshold**.
4. Select **Purge**.


## Purge SLO rollup data

<applies-to>
  - Elastic Stack: Generally available since 9.1
</applies-to>

Rollup functionality summarizes old, high-granularity data into a reduced granularity format for long-term storage. Occasionally, you might want to delete this rollup data.

### Bulk purge SLO rollup data

To bulk purge SLO rollup data:
1. From the **SLO Management** page, select the checkbox next to the SLOs from which you want to purge rollup data.
2. From the **Selected [number] SLOs** menu, select **Purge rollup data**.
3. Define which data to purge.
4. Select **Purge**.


### Purge rollup data from a single SLO

To purge rollup data from a specific SLO:
1. Open the **Actions** menu (`boxes_vertical`) for the SLO from which you want to purge rollup data.
2. Select **Purge rollup data**.
3. Define which data to purge.
4. Select **Purge**.