﻿---
title: Create a TLS certificate rule
description: In Kibana, you can create a rule that notifies you when one or more of your monitors has a TLS certificate expiring within a specified threshold, or when...
url: https://www.elastic.co/docs/solutions/observability/incident-management/create-tls-certificate-rule
products:
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# Create a TLS certificate rule
In Kibana, you can create a rule that notifies you when one or more of your monitors has a TLS certificate expiring within a specified threshold, or when it exceeds an age limit.
There are two types of TLS certificate rule:
- [Synthetics TLS certificate rule](#tls-rule-synthetics) for use with [Elastic Synthetics](https://www.elastic.co/docs/solutions/observability/synthetics).
- [Uptime TLS rule](#tls-rule-uptime) for use with the Uptime app.
  <admonition title="Deprecated in 8.15.0">
  Uptime was deprecated in 8.15.0. Use Synthetics instead.
  </admonition>


## Synthetics TLS certificate rule

Within the Synthetics UI, create a **TLS certificate** rule to receive notifications based on errors and outages.

### Conditions

You can specify the following thresholds for your rule:

|                          |                                                                                                                                                 |
|--------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------|
| **Expiration threshold** | The `HAS A CERTIFICATE EXPIRING WITHIN DAYS` condition specifies when you are notifiedabout certificates that are approaching expiration dates. |
| **Age limit**            | The `OR OLDER THAN DAYS` condition specifies when you are notified about certificatesthat have been valid for too long.                         |

The **Rule schedule** defines how often to evaluate the condition.
You can also set **Advanced options** such as the number of consecutive runs that must meet the rule conditions before an alert occurs.
In this example, the conditions are met when any of the TLS certificates on sites we’re monitoring is expiring within 30 days or is older than 730 days. These conditions are evaluated every 6 hours, and you will only receive an alert when the conditions are met three times consecutively.
![Conditions and advanced options defining a Synthetics TLS certificate rule](https://www.elastic.co/docs/solutions/images/observability-tls-rule-synthetics-conditions.png)


### Action types

Extend your rules by connecting them to actions that use the following supported built-in integrations.
- [D3 Security](https://www.elastic.co/docs/reference/kibana/connectors-kibana/d3security-action-type)
- [Email](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type)
- [IBM Resilient](https://www.elastic.co/docs/reference/kibana/connectors-kibana/resilient-action-type)
- [Index](https://www.elastic.co/docs/reference/kibana/connectors-kibana/index-action-type)
- [Jira](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jira-action-type)
- [Microsoft Teams](https://www.elastic.co/docs/reference/kibana/connectors-kibana/teams-action-type)
- [Observability AI Assistant connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/obs-ai-assistant-action-type)
- [Opsgenie](https://www.elastic.co/docs/reference/kibana/connectors-kibana/opsgenie-action-type)
- [PagerDuty](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pagerduty-action-type)
- [Server log](https://www.elastic.co/docs/reference/kibana/connectors-kibana/server-log-action-type)
- [ServiceNow ITOM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type)
- [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type)
- [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type)
- [Slack](https://www.elastic.co/docs/reference/kibana/connectors-kibana/slack-action-type)
- [Swimlane](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type)
- [Torq](https://www.elastic.co/docs/reference/kibana/connectors-kibana/torq-action-type)
- [Webhook](https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type)
- [xMatters](https://www.elastic.co/docs/reference/kibana/connectors-kibana/xmatters-action-type)

<note>
  Some connector types are paid commercial features, while others are free. For a comparison of the Elastic subscription levels, go to [the subscription page](https://www.elastic.co/subscriptions).
</note>

After you select a connector, you must set the action frequency. You can choose to create a summary of alerts on each check interval or on a custom interval. For example, send email notifications that summarize the new, ongoing, and recovered alerts each hour:
![tls rule synthetics action types summary](https://www.elastic.co/docs/solutions/images/observability-tls-rule-synthetics-action-types-summary.png)

Alternatively, you can set the action frequency such that you choose how often the action runs (for example, at each check interval, only when the alert status changes, or at a custom action interval). In this case, you must also select the specific threshold condition that affects when actions run: the *Synthetics TLS certificate* changes or when it is *Recovered* (went from down to up).
![tls rule synthetics action types each alert](https://www.elastic.co/docs/solutions/images/observability-tls-rule-synthetics-action-types-each-alert.png)

You can also further refine the conditions under which actions run by specifying that actions only run when they match a KQL query or when an alert occurs within a specific time frame:
- **If alert matches query**: Enter a KQL query that defines field-value pairs or query conditions that must be met for notifications to send. The query only searches alert documents in the indices specified for the rule.
- **If alert is generated during timeframe**: Set timeframe details. Notifications are only sent if alerts are generated within the timeframe you define.

![tls rule synthetics action types more options](https://www.elastic.co/docs/solutions/images/observability-tls-rule-synthetics-action-types-more-options.png)


#### Action variables

Use the default notification message or customize it. You can add more context to the message by clicking the icon above the message text box and selecting from a list of available variables.
![tls rule synthetics action variables](https://www.elastic.co/docs/solutions/images/observability-tls-rule-synthetics-action-variables.png)

The following variables are specific to this rule type. You an also specify [variables common to all rules](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/rule-action-variables).
<definitions>
  <definition term="context.checkedAt">
    Timestamp of the monitor run.
  </definition>
  <definition term="context.hostName">
    Hostname of the location from which the check is performed.
  </definition>
  <definition term="context.labels">
    Labels associated with the monitor.
  </definition>
  <definition term="context.lastErrorMessage">
    Monitor last error message.
  </definition>
  <definition term="context.lastErrorStack">
    Monitor last error stack trace.
  </definition>
  <definition term="context.locationId">
    Location ID from which the check is performed.
  </definition>
  <definition term="context.locationName">
    Location name from which the check is performed.
  </definition>
  <definition term="context.locationNames">
    Location names from which the checks are performed.
  </definition>
  <definition term="context.monitorType">
    Type (for example, HTTP/TCP) of the monitor.
  </definition>
  <definition term="context.monitorUrl">
    URL of the monitor.
  </definition>
  <definition term="context.reason">
    A concise description of the reason for the alert.
  </definition>
  <definition term="context.recoveryReason">
    A concise description of the reason for the recovery.
  </definition>
  <definition term="context.serviceName">
    Service name associated with the monitor.
  </definition>
  <definition term="context.status">
    Monitor status (for example, "down").
  </definition>
  <definition term="context.viewInAppUrl">
    Open alert details and context in Synthetics app.
  </definition>
</definitions>


## Uptime TLS rule

<applies-to>
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Deprecated since 8.15
</applies-to>

<admonition title="Deprecated in 8.15.0.">
  Use [Synthetic monitoring](https://www.elastic.co/docs/solutions/observability/synthetics) instead of the Uptime app.
</admonition>

Within the Uptime app, create a **TLS certificate** rule to receive notifications based on errors and outages.

### Filters

The **Filter by** section controls the scope of the rule. The rule will only check monitors that match the filters defined in this section.

### Conditions

You can specify the following thresholds for your rule:

|                          |                                                                                                                                                 |
|--------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------|
| **Expiration threshold** | The `HAS A CERTIFICATE EXPIRING WITHIN DAYS` threshold specifies when you are notifiedabout certificates that are approaching expiration dates. |
| **Age limit**            | The `OR OLDER THAN DAYS` threshold specifies when you are notified about certificatesthat have been valid for too long.                         |

In this example, the conditions are met when any of the TLS certificates on sites we’re monitoring is expiring within 30 days or is older than 730 days. These conditions are evaluated every 6 hours, and you will only receive an alert when the conditions are met three times consecutively.
![Monitor status rule](https://www.elastic.co/docs/solutions/images/observability-tls-rule-uptime-conditions.png)


### Action types

Extend your rules by connecting them to actions that use the following supported built-in integrations. Actions are Kibana services or integrations with third-party systems that run as background tasks on the Kibana server when rule conditions are met.
You can configure action types on the [Settings](/docs/solutions/observability/uptime/configure-settings#configure-uptime-alert-connectors) page.
- [D3 Security](https://www.elastic.co/docs/reference/kibana/connectors-kibana/d3security-action-type)
- [Email](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type)
- [IBM Resilient](https://www.elastic.co/docs/reference/kibana/connectors-kibana/resilient-action-type)
- [Index](https://www.elastic.co/docs/reference/kibana/connectors-kibana/index-action-type)
- [Jira](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jira-action-type)
- [Microsoft Teams](https://www.elastic.co/docs/reference/kibana/connectors-kibana/teams-action-type)
- [Observability AI Assistant connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/obs-ai-assistant-action-type)
- [Opsgenie](https://www.elastic.co/docs/reference/kibana/connectors-kibana/opsgenie-action-type)
- [PagerDuty](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pagerduty-action-type)
- [Server log](https://www.elastic.co/docs/reference/kibana/connectors-kibana/server-log-action-type)
- [ServiceNow ITOM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type)
- [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type)
- [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type)
- [Slack](https://www.elastic.co/docs/reference/kibana/connectors-kibana/slack-action-type)
- [Swimlane](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type)
- [Torq](https://www.elastic.co/docs/reference/kibana/connectors-kibana/torq-action-type)
- [Webhook](https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type)
- [xMatters](https://www.elastic.co/docs/reference/kibana/connectors-kibana/xmatters-action-type)

<note>
  Some connector types are paid commercial features, while others are free. For a comparison of the Elastic subscription levels, go to [the subscription page](https://www.elastic.co/subscriptions).
</note>

After you select a connector, you must set the action frequency. You can choose to create a summary of alerts on each check interval or on a custom interval. For example, send email notifications that summarize the new, ongoing, and recovered alerts each hour:
![tls rule uptime action types summary](https://www.elastic.co/docs/solutions/images/observability-tls-rule-uptime-action-types-summary.png)

Alternatively, you can set the action frequency such that you choose how often the action runs (for example, at each check interval, only when the alert status changes, or at a custom action interval). In this case, you must also select the specific threshold condition that affects when actions run: *Uptime TLS Alert* or *Recovered* (went from down to up).
![tls rule uptime action types each alert](https://www.elastic.co/docs/solutions/images/observability-tls-rule-uptime-action-types-each-alert.png)

You can also further refine the conditions under which actions run by specifying that actions only run when they match a KQL query or when an alert occurs within a specific time frame:
- **If alert matches query**: Enter a KQL query that defines field-value pairs or query conditions that must be met for notifications to send. The query only searches alert documents in the indices specified for the rule.
- **If alert is generated during timeframe**: Set timeframe details. Notifications are only sent if alerts are generated within the timeframe you define.

![tls rule uptime action types more options](https://www.elastic.co/docs/solutions/images/observability-tls-rule-uptime-action-types-more-options.png)


#### Action variables

Use the default notification message or customize it. You can add more context to the message by clicking the icon above the message text box and selecting from a list of available variables.
![Default notification message for TLS rules with open "Add variable" popup listing available action variables](https://www.elastic.co/docs/solutions/images/observability-tls-rule-uptime-default-message.png)

The following variables are specific to this rule type. You an also specify [variables common to all rules](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/rule-action-variables).
<definitions>
  <definition term="context.agingCommonNameAndDate">
    The common names and expiration date/time of the detected certs.
  </definition>
  <definition term="context.agingCount">
    The number of detected certs that are becoming too old.
  </definition>
  <definition term="context.alertDetailsUrl">
    Link to the alert troubleshooting view for further context and details. This will be an empty string if the `server.publicBaseUrl` is not configured.
  </definition>
  <definition term="context.count">
    The number of certs detected by the alert executor.
  </definition>
  <definition term="context.currentTriggerStarted">
    Timestamp indicating when the current trigger state began, if alert is triggered.
  </definition>
  <definition term="context.expiringCommonNameAndDate">
    The common names and expiration date/time of the detected certs.
  </definition>
  <definition term="context.expiringCount">
    The number of expiring certs detected by the alert.
  </definition>
  <definition term="context.firstCheckedAt">
    Timestamp indicating when this alert first checked.
  </definition>
  <definition term="context.firstTriggeredAt">
    Timestamp indicating when the alert first triggered.
  </definition>
  <definition term="context.isTriggered">
    Flag indicating if the alert is currently triggering.
  </definition>
  <definition term="context.lastCheckedAt">
    Timestamp indicating the alert’s most recent check time.
  </definition>
  <definition term="context.lastResolvedAt">
    Timestamp indicating the most recent resolution time for this alert.
  </definition>
  <definition term="context.lastTriggeredAt">
    Timestamp indicating the alert’s most recent trigger time.
  </definition>
</definitions>