﻿---
title: Create a metric threshold rule
description: Based on the metrics that are listed on the Metrics Explorer page within the Infrastructure app, you can create a threshold rule to notify you when a...
url: https://www.elastic.co/docs/solutions/observability/incident-management/create-metric-threshold-rule
products:
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# Create a metric threshold rule
Based on the metrics that are listed on the **Metrics Explorer** page within the Infrastructure app, you can create a threshold rule to notify you when a metric has reached or exceeded a value for a specific time period.
Additionally, each rule can be defined using multiple conditions that combine metrics and thresholds to create precise notifications.
<tip>
  When you create this rule on the **Metrics Explorer** page, the rule is automatically populated with the same parameters as the page. If you’ve chosen a **graph per** value, your rule is preconfigured to monitor and notify about each individual graph displayed on the page.You can also create a rule based on a single graph. On the **Metrics Explorer** page, click **Alerts and rules** → **Create alert**. The condition and filter sections of the threshold rule are automatically populated.
</tip>


## Metric conditions

Conditions for each rule can be applied to specific metrics that you select. You can select the aggregation type (refer to [Aggregation options](https://www.elastic.co/docs/solutions/observability/incident-management/aggregation-options)), the metric, and by including a warning threshold value, you can be alerted on multiple threshold values based on severity scores. To help you determine which thresholds are meaningful to you, the preview charts provide a visualization.
In this example, the conditions state that you receive a critical alert for hosts with a CPU usage of 120% or above and a warning alert if CPU usage is 100% or above. Note that you will receive an alert only if memory usage is 20% or above, as per the second condition.
<applies-to>Elastic Stack: Removed in 9.1, Elastic Stack: Generally available in 9.0</applies-to> When you select **Alert me if there’s no data**, the rule is triggered if the metrics don’t report any data over the expected time period, or if the rule fails to query Elasticsearch.
![Metric threshold alert with alert if there is no data](https://www.elastic.co/docs/solutions/images/observability-metrics-alert-nodata.png)


## Filtering and grouping

The **Filters** control the scope of the rule. If used, the rule will only evaluate metric data that matches the query in this field. In this example, the rule will only alert on metrics reported from a Cloud region called `us-east`.
<note>
  If you've made a rule with the [create rule API](https://www.elastic.co/docs/api/doc/kibana/operation/operation-post-alerting-rule-id) and added Query DSL filters using the `filterQuery` parameter, the filters won't appear in the UI for editing a rule. As a workaround, manually re-add the filters through the UI and save the rule. As you're modifying the rule's filters from the UI, be mindful of the following:
  - The **Filter** field only accepts KQL syntax, meaning you may need to manually convert your Query DSL filters to KQL.
  - After you save the rule, filters you've added to the **Filter** field are converted appropriately and specified in the rule's `filterQuery` parameter.
</note>

The **Group alerts by** creates an instance of the alert for every unique value of the `field` added. For example, you can create a rule per host or every mount point of each host. You can also add multiple fields. In this example, the rule will individually track the status of each `host.name` in your infrastructure. You will only receive an alert about `host-1`, if `host.name: host-1` passes the threshold, but `host-2` and `host-3` do not.
<important>
  If you include the same field in both your **Filter** and your **Group by**, you may receive fewer results than you’re expecting. For example, if you filter by `cloud.region: us-east`, then grouping by `cloud.region` will have no effect because the filter query can only match one region.
</important>

<applies-switch>
  <applies-item title="stack: ga 9.1+" applies-to="Elastic Stack: Generally available since 9.1">
    If there is no data, you have the following options to control the alert behavior:
    ![Metric threshold alert with alert if there is no data](https://www.elastic.co/docs/solutions/images/observability-metrics-alertfiltersandgroup-nodata-options.png)

    - **Recover active alerts**: Recover active alerts when data is missing; no new alerts are created.
    - **Alert me about the missing data**
      - If **Group alerts by** is used: Trigger a “no data” alert when a previously detected group stops reporting data; not recommended for dynamically scaling infrastructures that start and stop nodes automatically.
    - If **Group alerts by** is not used: Trigger a “no data” alert when no data is returned during rule execution, or when the rule fails to query Elasticsearch.
    - **Do nothing**: Keep active alerts unchanged and do not create new alerts for missing data.
  </applies-item>

  <applies-item title="stack: ga =9.0" applies-to="Elastic Stack: Generally available in 9.0">
    When you select **Alert me if a group stops reporting data**, the rule is triggered if a group that previously reported metrics does not report them again over the expected time period.
    ![Metric threshold alert with alert if there is no data](https://www.elastic.co/docs/solutions/images/observability-metrics-alertfiltersandgroup-nodata-alert.png)
  </applies-item>
</applies-switch>

In the **Advanced options**, you can change the number of consecutive runs that must meet the rule conditions before an alert occurs. The default value is `1`.

## Action types

Extend your rules by connecting them to actions that use the following supported built-in integrations.
- [D3 Security](https://www.elastic.co/docs/reference/kibana/connectors-kibana/d3security-action-type)
- [Email](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type)
- [IBM Resilient](https://www.elastic.co/docs/reference/kibana/connectors-kibana/resilient-action-type)
- [Index](https://www.elastic.co/docs/reference/kibana/connectors-kibana/index-action-type)
- [Jira](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jira-action-type)
- [Microsoft Teams](https://www.elastic.co/docs/reference/kibana/connectors-kibana/teams-action-type)
- [Observability AI Assistant connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/obs-ai-assistant-action-type)
- [Opsgenie](https://www.elastic.co/docs/reference/kibana/connectors-kibana/opsgenie-action-type)
- [PagerDuty](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pagerduty-action-type)
- [Server log](https://www.elastic.co/docs/reference/kibana/connectors-kibana/server-log-action-type)
- [ServiceNow ITOM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type)
- [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type)
- [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type)
- [Slack](https://www.elastic.co/docs/reference/kibana/connectors-kibana/slack-action-type)
- [Swimlane](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type)
- [Torq](https://www.elastic.co/docs/reference/kibana/connectors-kibana/torq-action-type)
- [Webhook](https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type)
- [xMatters](https://www.elastic.co/docs/reference/kibana/connectors-kibana/xmatters-action-type)

<note>
  Some connector types are paid commercial features, while others are free. For a comparison of the Elastic subscription levels, go to [the subscription page](https://www.elastic.co/subscriptions).
</note>

After you select a connector, you must set the action frequency. You can choose to create a summary of alerts on each check interval or on a custom interval. For example, send email notifications that summarize the new, ongoing, and recovered alerts each hour:
![Action types](https://www.elastic.co/docs/solutions/images/observability-action-alert-summary.png)

Alternatively, you can set the action frequency such that you choose how often the action runs (for example, at each check interval, only when the alert status changes, or at a custom action interval). In this case, you must also select the specific threshold condition that affects when actions run: `Alert`, `Warning`, `No data`, or `Recovered` (a value that was once above a threshold has now dropped below it).
![Configure when a rule is triggered](https://www.elastic.co/docs/solutions/images/observability-metrics-threshold-run-when-selection.png)

You can also further refine the conditions under which actions run by specifying that actions only run when they match a KQL query or when an alert occurs within a specific time frame:
- **If alert matches query**: Enter a KQL query that defines field-value pairs or query conditions that must be met for notifications to send. The query only searches alert documents in the indices specified for the rule.
- **If alert is generated during timeframe**: Set timeframe details. Notifications are only sent if alerts are generated within the timeframe you define.

![Configure a conditional alert](https://www.elastic.co/docs/solutions/images/observability-metric-threshold-conditional-alerts.png)


## Action variables

Use the default notification message or customize it. You can add more context to the message by clicking the icon above the message text box and selecting from a list of available variables.
![Default notification message for metric threshold rules with open "Add variable" popup listing available action variables](https://www.elastic.co/docs/solutions/images/observability-metrics-threshold-alert-default-message.png)

The following variables are specific to this rule type. You an also specify [variables common to all rules](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/rule-action-variables).
<definitions>
  <definition term="context.alertDetailsUrl">
    Link to the alert troubleshooting view for further context and details. This will be an empty string if the `server.publicBaseUrl` is not configured.
  </definition>
  <definition term="context.alertState">
    Current state of the alert.
  </definition>
  <definition term="context.cloud">
    The cloud object defined by ECS if available in the source.
  </definition>
  <definition term="context.container">
    The container object defined by ECS if available in the source.
  </definition>
  <definition term="context.group">
    Name of the group(s) reporting data. For accessing each group key, use `context.groupByKeys`.
  </definition>
  <definition term="context.groupByKeys">
    The object containing groups that are reporting data.
  </definition>
  <definition term="context.grouping Elastic Stack: Generally available since 9.2">
    The object containing groups that are reporting data.
  </definition>
  <definition term="context.host">
    The host object defined by ECS if available in the source.
  </definition>
  <definition term="context.labels">
    List of labels associated with the entity where this alert triggered.
  </definition>
  <definition term="context.metric">
    The metric name in the specified condition. Usage: (`ctx.metric.condition0`, `ctx.metric.condition1`, and so on).
  </definition>
  <definition term="context.orchestrator">
    The orchestrator object defined by ECS if available in the source.
  </definition>
  <definition term="context.originalAlertState">
    The state of the alert before it recovered. This is only available in the recovery context.
  </definition>
  <definition term="context.originalAlertStateWasALERT">
    Boolean value of the state of the alert before it recovered. This can be used for template conditions. This is only available in the recovery context.
  </definition>
  <definition term="context.originalAlertStateWasNO_DATA">
    Boolean value of the state of the alert before it recovered. This can be used for template conditions. This is only available in the recovery context.
  </definition>
  <definition term="context.originalAlertStateWasWARNING">
    Boolean value of the state of the alert before it recovered. This can be used for template conditions. This is only available in the recovery context.
  </definition>
  <definition term="context.reason">
    A concise description of the reason for the alert.
  </definition>
  <definition term="context.tags">
    List of tags associated with the entity where this alert triggered.
  </definition>
  <definition term="context.threshold">
    The threshold value of the metric for the specified condition. Usage: (`ctx.threshold.condition0`, `ctx.threshold.condition1`, and so on)
  </definition>
  <definition term="context.timestamp">
    A timestamp of when the alert was detected.
  </definition>
  <definition term="context.value">
    The value of the metric in the specified condition. Usage: (`ctx.value.condition0`, `ctx.value.condition1`, and so on)
  </definition>
  <definition term="context.viewInAppUrl">
    Link to the alert source.
  </definition>
</definitions>


## Settings

With metric threshold rules, it’s not possible to set an explicit index pattern as part of the configuration. The index pattern is instead inferred from **Metrics indices** on the [Settings](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/configure-settings) page of the Infrastructure app.
With each execution of the rule check, the **Metrics indices** setting is checked, but it is not stored when the rule is created.
The **Timestamp** field that is set under **Settings** determines which field is used for timestamps in queries.