﻿---
title: Create and manage rules for Elastic Observability
description: Alerting enables you to define rules, which detect complex conditions within different apps and trigger actions when those conditions are met. Alerting...
url: https://www.elastic.co/docs/solutions/observability/incident-management/create-manage-rules
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Create and manage rules for Elastic Observability
<note>
  **For Observability serverless projects**, the **Editor** role or higher is required to create and manage rules for alerting. To learn more, refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles).
</note>

Alerting enables you to define *rules*, which detect complex conditions within different apps and trigger actions when those conditions are met. Alerting provides a set of built-in connectors and rules for you to use.

## Observability rules

Learn more about Observability rules and how to create them:

| Rule type        | Name                                                                                                                                                       | Detects when…                                                                        |
|------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------|
| AIOps            | [Anomaly detection](https://www.elastic.co/docs/solutions/observability/incident-management/create-an-apm-anomaly-rule)                                    | Anomalies match specific conditions.                                                 |
| APM              | [APM anomaly](https://www.elastic.co/docs/solutions/observability/incident-management/create-an-apm-anomaly-rule)                                          | The latency, throughput, or failed transaction rate of a service is abnormal.        |
| Observability    | [Custom threshold](https://www.elastic.co/docs/solutions/observability/incident-management/create-custom-threshold-rule)                                   | An Observability data type reaches or exceeds a given value.                         |
| Data set quality | [Degraded docs](https://www.elastic.co/docs/solutions/observability/incident-management/create-a-degraded-docs-rule)                                       | The percentage of degraded documents for a data view exceeds a threshold             |
| Stack            | [Elasticsearch query](https://www.elastic.co/docs/solutions/observability/incident-management/create-an-elasticsearch-query-rule)                          | Matches are found during the latest query run.                                       |
| APM              | [Error count threshold](https://www.elastic.co/docs/solutions/observability/incident-management/create-an-error-count-threshold-rule)                      | The number of errors in a service exceeds a defined threshold.                       |
| APM              | [Failed transaction rate threshold](https://www.elastic.co/docs/solutions/observability/incident-management/create-failed-transaction-rate-threshold-rule) | The rate of transaction errors in a service exceeds a defined threshold.             |
| Metrics          | [Inventory](https://www.elastic.co/docs/solutions/observability/incident-management/create-an-inventory-rule)                                              | The infrastructure inventory exceeds a defined threshold.                            |
| Logs             | [Log threshold](https://www.elastic.co/docs/solutions/observability/incident-management/create-log-threshold-rule)                                         | An Observability data type reaches or exceeds a given value.                         |
| Metrics          | [Metric threshold](https://www.elastic.co/docs/solutions/observability/incident-management/create-metric-threshold-rule)                                   | An Observability data type reaches or exceeds a given value.                         |
| APM              | [Latency threshold](https://www.elastic.co/docs/solutions/observability/incident-management/create-latency-threshold-rule)                                 | The latency of a specific transaction type in a service exceeds a defined threshold. |
| SLO              | [SLO burn rate rule](https://www.elastic.co/docs/solutions/observability/incident-management/create-an-slo-burn-rate-rule)                                 | The burn rate is above a defined threshold.                                          |


## Creating rules and alerts

You start by defining the rule and how often it should be evaluated. You can extend these rules by adding an appropriate action (for example, send an email or create an issue) to be triggered when the rule conditions are met. These actions are defined within each rule and implemented by the appropriate connector for that action e.g. Slack, Jira. You can create any rules from scratch using the **Manage Rules** page, or you can create specific rule types from their respective UIs and benefit from some of the details being pre-filled (for example, Name and Tags).
- For APM alert types, you can select **Alerts and rules** and create rules directly from the **Services**, **Traces**, and **Dependencies** UIs.
- For SLO alert types, from the **SLOs** page open the **More actions** menu ![action menu](https://www.elastic.co/docs/solutions/images/serverless-boxesHorizontal.svg) for an SLO and select **Create new alert rule**. Alternatively, when you create a new SLO, the **Create new SLO burn rate alert rule** checkbox is enabled by default and will prompt you to [Create SLO burn rate rule](https://www.elastic.co/docs/solutions/observability/incident-management/create-an-slo-burn-rate-rule) upon saving the SLO.

After a rule is created, you can open the **More actions** menu ![More actions](https://www.elastic.co/docs/solutions/images/serverless-boxesHorizontal.svg) and select **Edit rule** to check or change the definition, and/or add or modify actions.
![Edit rule (failed transaction rate)](https://www.elastic.co/docs/solutions/images/serverless-alerts-edit-rule.png)

From the action menu you can also:
- Disable or delete rule
- Clone rule
- Snooze rule notifications
- Run rule (without waiting for next scheduled check)
- Update API keys


## View rule details

Click on an individual rule on the **Rules** page to view details including the rule name, status, definition, execution history, related alerts, and more.
![Rule details (APM anomaly)](https://www.elastic.co/docs/solutions/images/serverless-alerts-detail-apm-anomaly.png)

A rule can have one of the following responses:
<definitions>
  <definition term="failed">
    The rule ran with errors.
  </definition>
  <definition term="succeeded">
    The rule ran without errors.
  </definition>
  <definition term="warning">
    The rule ran with some non-critical errors.
  </definition>
</definitions>


## Snooze and disable rules

The rule listing enables you to quickly snooze, disable, enable, or delete individual rules.
When you snooze a rule, the rule checks continue to run on a schedule but the alert will not trigger any actions. You can snooze for a specified period of time, indefinitely, or schedule single or recurring downtimes.
When a rule is in a snoozed state, you can cancel or change the duration of this state.
To temporarily suppress notifications for *all* rules, create a [maintenance window](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/maintenance-windows).

## Import and export rules

To import and export rules, use [Saved Objects](https://www.elastic.co/docs/explore-analyze/find-and-organize).
Rules are disabled on export. You are prompted to re-enable the rule on successful import.

## Add resources for investigating alerts

<applies-to>
  - Elastic Stack: Generally available since 9.1
</applies-to>

When creating or editing a rule, add the following resources to help you get started with investigating alerts:
- **Investigation guide**: Investigation guides can help you respond to alerts more efficiently and consistently. When creating them, you can include instructions for responding to alerts, links to external supporting materials, and more. When the rule generates an alert, the investigation guide can be accessed from the **Investigation guide** tab on the alert's details page.
  <tip>
  Use Markdown to format and structure text in your investigation guide.
  </tip>
- **Related and suggested dashboards**: Link to dashboards that provide useful insights about your environment, active events, and any other information that might be relevant during your investigations. When the rule generates an alert, linked dashboards can be accessed from the **Related dashboards** tab on the alert's details page. From the tab, you can also review and add suggested dashboards (available for custom threshold rules only).


## Configure alert flapping

You can modify the criteria for changing an alert's status to [flapping state](/docs/solutions/observability/incident-management/view-alerts#observability-view-alerts-understand-statuses) by configuring the **Alert flapping detection** settings, which are turned on by default. When configuring flapping settings, you must set a look back window and threshold for alert status changes. For example, you can specify that alerts with at least 6 status changes in the last 10 runs are `flapping`.
<applies-to>Elastic Stack: Generally available since 9.3</applies-to> You can modify the flapping settings for a specific rule while creating or editing it. You can also modify the flapping settings for all rules in your Kibana space or Serverless project. To do this, go to the **Rules** page (find the **Rules** management page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects)), click **Settings**, then go to the **Alert flapping detection** settings.
<applies-to>Elastic Stack: Generally available from 9.0 to 9.2</applies-to> You can only modify global flapping settings for your entire Kibana space or Serverless project.