﻿---
title: Create and manage cases
description: Open a new Observability case to keep track of issues and share the details with colleagues. You can create and manage cases using the cases UI. To create...
url: https://www.elastic.co/docs/solutions/observability/incident-management/create-manage-cases
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Serverless Observability projects: Generally available
  - Elastic Stack: Generally available
---

# Create and manage cases
Open a new Observability case to keep track of issues and share the details with colleagues. You can create and manage cases using the cases UI.
<applies-switch>
  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    **Requirements**For Observability projects, you need the appropriate [feature tier](https://www.elastic.co/pricing), and your role must have the **Editor** role or higher to create and manage cases. To learn more, refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles).
  </applies-item>

  <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
    **Requirements**To access and send cases to external systems, you need the appropriate [subscription](https://www.elastic.co/pricing), and your role must have the required Kibana feature privileges. Refer to [Configure access to cases in Elastic Observability](https://www.elastic.co/docs/solutions/observability/incident-management/configure-access-to-cases) for more information.
  </applies-item>
</applies-switch>


## Create a case

To create a case:
1. Find **Cases** in the main menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Click **Create case**.
3. <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to> (Optional) If you defined [templates](/docs/solutions/observability/incident-management/configure-case-settings#observability-case-templates), select one to use its default field values.
4. Give the case a name, severity, and description.
   <tip>
   In the **Description**, you can use [Markdown](https://www.markdownguide.org/cheat-sheet) syntax to format text.
   </tip>
5. (Optional) Add a category, assignees, and tags.
   <applies-switch>
   <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
   You can add users who are assigned the **Editor** user role (or a more permissive role) for the project.
   </applies-item>

   <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
   You can add users only if they meet the necessary [prerequisites](https://www.elastic.co/docs/solutions/observability/incident-management/configure-access-to-cases).
   </applies-item>
   </applies-switch>
6. If you defined [custom fields](/docs/solutions/observability/incident-management/configure-case-settings#case-custom-fields), they appear in the **Additional fields** section.
7. (Optional) Under **External Connector Fields**, you can select a connector to send cases to an external system. If you’ve created any connectors previously, they will be listed here. If there are no connectors listed, you can create one. For more information, refer to [External incident management systems](/docs/solutions/observability/incident-management/configure-case-settings#cases-external-connectors).
   <note applies-to="Elastic Stack: Generally available since 9.3">
   When specifying **Additional fields** for an IBM Resilient connector, fields that are set when an incident is created or changed (for example, an incident is closed) won't display as an option.
   </note>
8. After you’ve completed all of the required fields, click **Create case**.

<tip>
  You can also create a case from an alert or add an alert to an existing case. From the **Alerts** page, click the **More options** ![More actions](https://www.elastic.co/docs/solutions/images/serverless-boxesHorizontal.svg) icon and choose either **Add to existing case** or **Create new case**, and select or complete the details as required.
</tip>


## Send cases to external incident management systems

To send a case to an external system, click the ![push](https://www.elastic.co/docs/solutions/images/serverless-importAction.svg) button in the **External incident management system** section of the individual case page. This information is not sent automatically. If you make further changes to the shared case fields, you should push the case again.
For more information about configuring connections to external incident management systems, refer to [Configure case settings for Elastic Observability](https://www.elastic.co/docs/solutions/observability/incident-management/configure-case-settings).

## Manage existing cases

You can search existing cases and filter them by attributes such as assignees, categories, severity, status, and tags. You can also select multiple cases and use bulk actions to delete cases or change their attributes.
<applies-to>Elastic Stack: Generally available since 9.3</applies-to> To find cases that were created during a specific time range, use the date time picker above the Cases table. The default time selection is the last 30 days. Clicking **Show all cases** displays every Observability case in your space. The action also adjusts the starting time range to the date of when the first case was created.
To view a case, click on its name. You can then:
- Add and edit the case's description, comments, assignees, tags, status, severity, and category.
  <applies-to>Elastic Stack: Generally available since 9.2</applies-to> Copy and paste images into case comments using `Ctrl/Cmd` + `C` and `Ctrl/Cmd` + `V` shortcuts. Pasted images are preformatted in Markdown.
- Add a connector (if you did not select one while creating the case).
- Send updates to external systems (if external connections are configured).
- Refresh the case to retrieve the latest updates.


## Add context and supporting materials

Provide additional context and resources by adding the following to the case:
- [Alerts](#observability-create-a-new-case-examine-alerts)
- [Files](#observability-create-a-new-case-add-files)

<tip applies-to="Elastic Stack: Generally available since 9.3">
  From the **Attachments** tab, you can search for specific alert IDs and file names.
</tip>


### Add alerts

Escalate alerts and track them in a single place by attaching them to cases. To examine the alerts, click the **Alerts** tab in the case. In the table, alerts are organized from oldest to newest. To view alert details, click the **View details** button.
You can find the **Alerts** tab in the following places:
- <applies-to>Elastic Cloud Serverless: Generally available</applies-to> <applies-to>Elastic Stack: Generally available since 9.3</applies-to>: Go to the case's details page, then select the **Attachments** tab.
- <applies-to>Elastic Stack: Generally available from 9.0 to 9.2</applies-to>: Go to the case's details page.

<important>
  Each case can have a maximum of 1,000 alerts.
</important>

<note>
  [Add alerts](/docs/solutions/observability/incident-management/view-alerts#observability-view-alerts-add-alerts-to-cases) to new and existing cases from the **Alerts** page.
</note>


### Add files

After you create a case, you can upload and manage files on the **Files** tab. To find the tab:
- <applies-to>Elastic Stack: Generally available since 9.3</applies-to>: Go to the case's details page, then select the **Attachments** tab.
- <applies-to>Elastic Stack: Generally available since 9.0</applies-to>: Go to the case's details page.

To download or delete the file or copy the file hash to your clipboard, open the action menu `boxes_horizontal`. The available hash functions are MD5, SHA-1, and SHA-256.
When you upload a file, a comment is added to the case activity log. To view an image, click its name in the activity or file list.
<important>
  When you export cases as [saved objects](https://www.elastic.co/docs/explore-analyze/find-and-organize/saved-objects), the attached case files are not exported.
</important>

<note>
  Uploaded files are also accessible from the **Files** management page, which you can find using the navigation menu or entering `Files` into the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
</note>


## Search cases

The **Cases** page has a search bar for quickly finding cases and case data. You can search for case titles, descriptions, and IDs using keywords and text. Note the following rules for search:
- **Keywords**: Searches for keywords (like case and alert IDs) must be exact.
- **Text**: Text searches (such as case titles and descriptions) are case-insensitive.
- **Syntax**: No special syntax is required when entering your search criteria.

<applies-to>Elastic Stack: Generally available since 9.3</applies-to> You can also search for alert and event IDs, observable values, case comments, and custom fields (text type only). For example, you can search for a specific IP address that's been specified as an observable, a colleague's comment, or the ID of an alert that's attached to the case.