﻿---
title: Create an uptime duration anomaly rule
description: Within the Uptime app, create an Uptime duration anomaly rule to receive notifications based on the response durations for all of the geographic locations...
url: https://www.elastic.co/docs/solutions/observability/incident-management/create-an-uptime-duration-anomaly-rule
products:
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Deprecated since 8.15
---

# Create an uptime duration anomaly rule
<admonition title="Deprecated in 8.15.0.">
  Use [Synthetic monitoring](https://www.elastic.co/docs/solutions/observability/synthetics) instead of the Uptime app.
</admonition>

Within the Uptime app, create an **Uptime duration anomaly** rule to receive notifications based on the response durations for all of the geographic locations of each monitor. When a monitor runs for an unusual amount of time, at a particular time, an anomaly is recorded and highlighted on the [Monitor duration](https://www.elastic.co/docs/solutions/observability/uptime/inspect-duration-anomalies) chart.

## Conditions

For each rule, you can configure which severity level triggers the alert. The default level is `critical`.
The *anomaly score* is a value from `0` to `100`, which indicates the significance of the anomaly compared to previously seen anomalies. The highly anomalous values are shown in red and the low scored values are indicated in blue.

|              |                       |
|--------------|-----------------------|
| **warning**  | Score `0` and above.  |
| **minor**    | Score `25` and above. |
| **major**    | Score `50` and above. |
| **critical** | Score `75` and above. |

![Uptime response duration rule](https://www.elastic.co/docs/solutions/images/observability-response-durations-alert.png)


## Action types

Extend your rules by connecting them to actions that use the following supported built-in integrations. Actions are Kibana services or integrations with third-party systems that run as background tasks on the Kibana server when rule conditions are met.
You can configure action types on the [Settings](/docs/solutions/observability/uptime/configure-settings#configure-uptime-alert-connectors) page.
- [D3 Security](https://www.elastic.co/docs/reference/kibana/connectors-kibana/d3security-action-type)
- [Email](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type)
- [IBM Resilient](https://www.elastic.co/docs/reference/kibana/connectors-kibana/resilient-action-type)
- [Index](https://www.elastic.co/docs/reference/kibana/connectors-kibana/index-action-type)
- [Jira](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jira-action-type)
- [Microsoft Teams](https://www.elastic.co/docs/reference/kibana/connectors-kibana/teams-action-type)
- [Observability AI Assistant connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/obs-ai-assistant-action-type)
- [Opsgenie](https://www.elastic.co/docs/reference/kibana/connectors-kibana/opsgenie-action-type)
- [PagerDuty](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pagerduty-action-type)
- [Server log](https://www.elastic.co/docs/reference/kibana/connectors-kibana/server-log-action-type)
- [ServiceNow ITOM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type)
- [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type)
- [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type)
- [Slack](https://www.elastic.co/docs/reference/kibana/connectors-kibana/slack-action-type)
- [Swimlane](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type)
- [Torq](https://www.elastic.co/docs/reference/kibana/connectors-kibana/torq-action-type)
- [Webhook](https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type)
- [xMatters](https://www.elastic.co/docs/reference/kibana/connectors-kibana/xmatters-action-type)

<note>
  Some connector types are paid commercial features, while others are free. For a comparison of the Elastic subscription levels, go to [the subscription page](https://www.elastic.co/subscriptions).
</note>

After you select a connector, you must set the action frequency. You can choose to create a summary of alerts on each check interval or on a custom interval. For example, send email notifications that summarize the new, ongoing, and recovered alerts every twelve hours:
![Action types](https://www.elastic.co/docs/solutions/images/observability-duration-anomaly-alert-summary.png)

Alternatively, you can set the action frequency such that you choose how often the action runs (for example, at each check interval, only when the alert status changes, or at a custom action interval). In this case, you must also select the specific threshold condition that affects when actions run: `Uptime Duration Anomaly` or `Recovered`.
![Configure when a rule is triggered](https://www.elastic.co/docs/solutions/images/observability-duration-anomaly-run-when-selection.png)


## Action variables

Use the default notification message or customize it. You can add more context to the message by clicking the icon above the message text box and selecting from a list of available variables.
![Default notification message for Uptime duration anomaly rules with open "Add variable" popup listing available action variables](https://www.elastic.co/docs/solutions/images/observability-duration-anomaly-alert-default-message.png)


## Alert recovery

To receive a notification when the alert recovers, select **Run when Recovered**. Use the default notification message or customize it. You can add more context to the message by clicking the icon above the message text box and selecting from a list of available variables.
![Default recovery message for Uptime duration anomaly rules with open "Add variable" popup listing available action variables](https://www.elastic.co/docs/solutions/images/observability-duration-anomaly-alert-recovery.png)