﻿---
title: Create an SLO burn rate rule
description: Create an SLO burn rate rule to get alerts when the burn rate is too high over a defined threshold for two different lookback periods: a long period and...
url: https://www.elastic.co/docs/solutions/observability/incident-management/create-an-slo-burn-rate-rule
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Create an SLO burn rate rule
<important>
  **For Observability serverless projects**, The **Editor** role or higher is required to create SLOs. To learn more, refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles).**For Elastic Stack**, to create and manage SLOs, you need an [appropriate license](https://www.elastic.co/subscriptions), an Elasticsearch cluster with both `transform` and `ingest` [node roles](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/node-settings#node-roles) present, and [SLO access](https://www.elastic.co/docs/solutions/observability/incident-management/configure-service-level-objective-slo-access) must be configured.
</important>

Create an SLO burn rate rule to get alerts when the burn rate is too high over a defined threshold for two different lookback periods: a long period and a short period that is 1/12th of the long period. For example, if your long lookback period is one hour, your short lookback period is five minutes.
Choose which SLO to monitor and then define multiple burn rate windows with appropriate severity. For each period, the burn rate is computed as the error rate divided by the error budget. When the burn rates for both periods surpass the threshold, an alert is triggered. Add actions to raise alerts via services or third-party integrations e.g. mail, Slack, Jira.
![Create rule for failed transaction rate threshold](https://www.elastic.co/docs/solutions/images/serverless-slo-alerts-create-rule.png)

<tip>
  These steps show how to use the **Alerts** UI. You can also create an SLO burn rate rule directly from **Observability** → **SLOs**. Click the more options icon (![More options](https://www.elastic.co/docs/solutions/images/serverless-boxesVertical.svg)) to the right of the SLO you want to add a burn rate rule for, and select **![Bell](https://www.elastic.co/docs/solutions/images/serverless-bell.svg) Create new alert rule** from the menu.When you use the UI to create an SLO, a default SLO burn rate alert rule is created automatically. The burn rate rule will use the default configuration and no connector. You must configure a connector if you want to receive alerts for SLO breaches.
</tip>

To create an SLO burn rate rule:
1. In Observability UI, go to **Alerts**.
2. Select **Manage Rules** from the **Alerts** page, and select **Create rule**.
3. Enter a **Name** for your rule, and any optional **Tags** for more granular reporting (leave blank if unsure).
4. Select **SLO burn rate** from the **Select rule type** list.
5. Select the **SLO** you want to monitor.
6. Define multiple burn rate windows for each **Action Group** (defaults to 4 windows but you can edit):
   - **Lookback (hours)**: Enter the lookback period for this window. A shorter period equal to 1/12th of this period will be used for faster recovery.
- **Burn rate threshold**: Enter a burn rate for this window.
- **Action Group**: Select a severity for this window.
7. Define the interval to check the rule e.g. check every 1 minute.
8. (Optional) Set up **Actions**.
9. **Save** your rule.


## Add actions

You can extend your rules with actions that interact with third-party systems, write to logs or indices, or send user notifications. You can add an action to a rule at any time. You can create rules without adding actions, and you can also define multiple actions for a single rule.
To add actions to rules, you must first create a connector for that service (for example, an email or external incident management system), which you can then use for different rules, each with their own action frequency.
<dropdown title="Connector types">
  Connectors provide a central place to store connection information for services and integrations with third party systems. The following connectors are available when defining actions for alerting rules:
  - [Cases](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-action-type)
  - [D3 Security](https://www.elastic.co/docs/reference/kibana/connectors-kibana/d3security-action-type)
  - [Email](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type)
  - [IBM Resilient](https://www.elastic.co/docs/reference/kibana/connectors-kibana/resilient-action-type)
  - [Index](https://www.elastic.co/docs/reference/kibana/connectors-kibana/index-action-type)
  - [Jira](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jira-action-type)
  - [Microsoft Teams](https://www.elastic.co/docs/reference/kibana/connectors-kibana/teams-action-type)
  - [Observability AI Assistant](https://www.elastic.co/docs/reference/kibana/connectors-kibana/obs-ai-assistant-action-type)
  - [Opsgenie](https://www.elastic.co/docs/reference/kibana/connectors-kibana/opsgenie-action-type)
  - [PagerDuty](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pagerduty-action-type)
  - [Server log](https://www.elastic.co/docs/reference/kibana/connectors-kibana/server-log-action-type)
  - [ServiceNow ITOM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type)
  - [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type)
  - [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type)
  - [Slack](https://www.elastic.co/docs/reference/kibana/connectors-kibana/slack-action-type)
  - [Swimlane](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type)
  - [Torq](https://www.elastic.co/docs/reference/kibana/connectors-kibana/torq-action-type)
  - [Webhook](https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type)
  - [xMatters](https://www.elastic.co/docs/reference/kibana/connectors-kibana/xmatters-action-type)

  <note>
    Some connector types are paid commercial features, while others are free. For a comparison of the Elastic subscription levels, go to [the subscription page](https://www.elastic.co/subscriptions).
  </note>
  For more information on creating connectors, refer to [Connectors](https://www.elastic.co/docs/deploy-manage/manage-connectors).
</dropdown>

<dropdown title="Action frequency">
  After you select a connector, you must set the action frequency. You can choose to create a **Summary of alerts** on each check interval or on a custom interval. For example, you can send email notifications that summarize the new, ongoing, and recovered alerts every twelve hours.Alternatively, you can set the action frequency to **For each alert** and specify the conditions each alert must meet for the action to run. For example, you can send an email only when the alert status changes to critical.
  ![Configure when a rule is triggered](https://www.elastic.co/docs/solutions/images/serverless-alert-action-frequency.png)
  With the **Run when** menu you can choose if an action runs for a specific severity (critical, high, medium, low), or when the alert is recovered. For example, you can add a corresponding action for each severity you want an alert for, and also for when the alert recovers.
  ![Choose between severity or recovered](https://www.elastic.co/docs/solutions/images/serverless-slo-action-frequency.png)
</dropdown>

<dropdown title="Action variables">
  Use the default notification message or customize it. You can add more context to the message by clicking the Add variable icon ![Add variable](https://www.elastic.co/docs/solutions/images/serverless-indexOpen.svg) and selecting from a list of available variables.
  ![Action variables list](https://www.elastic.co/docs/solutions/images/serverless-action-variables-popup.png)
  The following variables are specific to this rule type. You can also specify [variables common to all rules](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/rule-action-variables).
  <definitions>
    <definition term="context.alertDetailsUrl">
      Link to the alert troubleshooting view for further context and details. This will be an empty string if the `server.publicBaseUrl` is not configured.
    </definition>
    <definition term="context.burnRateThreshold">
      The burn rate threshold value.
    </definition>
    <definition term="context.grouping Elastic Stack: Generally available since 9.1">
      The object containing groups that are reporting data.
    </definition>
    <definition term="context.longWindow">
      The window duration with the associated burn rate value.
    </definition>
    <definition term="context.reason">
      A concise description of the reason for the alert.
    </definition>
    <definition term="context.shortWindow">
      The window duration with the associated burn rate value.
    </definition>
    <definition term="context.sloId">
      The SLO unique identifier.
    </definition>
    <definition term="context.sloInstanceId">
      The SLO instance ID.
    </definition>
    <definition term="context.sloName">
      The SLO name.
    </definition>
    <definition term="context.timestamp">
      A timestamp of when the alert was detected.
    </definition>
    <definition term="context.viewInAppUrl">
      The url to the SLO details page to help with further investigation.
    </definition>
  </definitions>
</dropdown>


## Next steps

Learn how to view alerts and triage SLO burn rate breaches:
- [View alerts](https://www.elastic.co/docs/solutions/observability/incident-management/view-alerts)
- [SLO burn rate breaches](https://www.elastic.co/docs/solutions/observability/incident-management/triage-slo-burn-rate-breaches)