﻿---
title: Create an anomaly detection rule
description: Create an anomaly detection rule to check for anomalies in one or more anomaly detection jobs. If the conditions of the rule are met, an alert is created,...
url: https://www.elastic.co/docs/solutions/observability/incident-management/create-an-anomaly-detection-rule
products:
  - Elastic Cloud Serverless
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Create an anomaly detection rule
<note>
  The **Editor** role or higher is required to create anomaly detection rules. To learn more, refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/manage-users#general-assign-user-roles).
</note>

<important>
  **Anomaly detection alerting is in beta**The Anomaly detection alerting functionality is in beta and is subject to change. The design and code is less mature than official generally available features and is being provided as-is with no warranties.
</important>

Create an anomaly detection rule to check for anomalies in one or more anomaly detection jobs. If the conditions of the rule are met, an alert is created, and any actions specified in the rule are triggered. For example, you can create a rule to check every fifteen minutes for critical anomalies and then alert you by email when they are detected.
To create an anomaly detection rule:
1. In your Elastic Observability Serverless project, go to **Machine learning** → **Jobs**.
2. In the list of anomaly detection jobs, find the job you want to check for anomalies. Haven’t created a job yet? [Create one now](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection).
3. From the **Actions** menu next to the job, select **Create alert rule**.
4. Specify a name and optional tags for the rule. You can use these tags later to filter alerts.
5. Verify that the correct job is selected or select a new one.
6. Select a type of machine learning result:
   | Choose…        | To generate an alert based on…                        |
   |----------------|-------------------------------------------------------|
   | **Bucket**     | How unusual the anomaly was within the bucket of time |
   | **Record**     | What individual anomalies are present in a time range |
   | **Influencer** | The most unusual entities in a time range             |
7. Adjust the **Severity** to match the anomaly score that will trigger the action. The anomaly score indicates the significance of a given anomaly compared to previous anomalies. The default severity threshold is 75, which means every anomaly with an anomaly score of 75 or higher will trigger the associated action.
8. <applies-to>Elastic Stack: Generally available since 9.3</applies-to><applies-to>Elastic Cloud Serverless: Generally available</applies-to> (Optional) To narrow down the list of anomalies that the rule looks for, add an **Anomaly filter**. This feature uses KQL and is only available for the Record and Influencer result types.
   In the **Anomaly filter** field, enter a KQL query that specifies fields or conditions to alert on. You can set up the following conditions:
   - One or more partitioning or influencers fields in the anomaly results match the specified conditions
- The actual or typical scores in the anomalies match specified conditions
   For example, say you've set up alerting for an anomaly detection job that has `partition_field = "response.keyword"` as the detector. If you were only interested in being alerted on `response.keyword = 404`, enter `partition_field_value: "404"` into the **Anomaly filter** field. When the rule runs, it will only alert on anomalies with `partition_field_value: "404"`.
   <note>
   When you edit the KQL query, suggested filter-by fields appear. To compare actual and typical values for any fields, use operators such as `>` (greater than), `<` (less than), or `=` (equal to).
   </note>
9. (Optional) Turn on **Include interim results** to include results that are created by the anomaly detection job *before* a bucket is finalized. These results might disappear after the bucket is fully processed. Include interim results to get notified earlier about potential anomalies, even if they might be false positives. Don't include interim results if you want to get notified only about anomalies of fully processed buckets.
10. (Optional) Expand and change **Advanced settings**:
   | Setting                      | Description                                                                                                                                                                                                                              |
   |------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
   | **Lookback interval**        | The interval used to query previous anomalies during each condition check. Setting the lookback interval lower than the default value might result in missed anomalies.                                                                  |
   | **Number of latest buckets** | The number of buckets to check to obtain the highest anomaly from all the anomalies that are found during the Lookback interval. An alert is created based on the anomaly with the highest anomaly score from the most anomalous bucket. |
11. (Optional) Under **Check the rule condition with an interval**, specify an interval, then click **Test** to check the rule condition with the interval specified. The button is grayed out if the datafeed is not started. To test the rule, start the data feed.
12. (Optional) If you want to change how often the condition is evaluated, adjust the **Check every** setting.
13. (Optional) Set up **Actions**.
14. **Save** your rule.

<note>
  Anomaly detection rules are defined as part of a job. Alerts generated by these rules do not appear on the **Alerts** page.
</note>


## Add actions

You can extend your rules with actions that interact with third-party systems, write to logs or indices, or send user notifications. You can add an action to a rule at any time. You can create rules without adding actions, and you can also define multiple actions for a single rule.
To add actions to rules, you must first create a connector for that service (for example, an email or external incident management system), which you can then use for different rules, each with their own action frequency.
<dropdown title="Connector types">
  Connectors provide a central place to store connection information for services and integrations with third party systems. The following connectors are available when defining actions for alerting rules:
  - [Cases](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-action-type)
  - [D3 Security](https://www.elastic.co/docs/reference/kibana/connectors-kibana/d3security-action-type)
  - [Email](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type)
  - [IBM Resilient](https://www.elastic.co/docs/reference/kibana/connectors-kibana/resilient-action-type)
  - [Index](https://www.elastic.co/docs/reference/kibana/connectors-kibana/index-action-type)
  - [Jira](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jira-action-type)
  - [Microsoft Teams](https://www.elastic.co/docs/reference/kibana/connectors-kibana/teams-action-type)
  - [Observability AI Assistant](https://www.elastic.co/docs/reference/kibana/connectors-kibana/obs-ai-assistant-action-type)
  - [Opsgenie](https://www.elastic.co/docs/reference/kibana/connectors-kibana/opsgenie-action-type)
  - [PagerDuty](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pagerduty-action-type)
  - [Server log](https://www.elastic.co/docs/reference/kibana/connectors-kibana/server-log-action-type)
  - [ServiceNow ITOM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type)
  - [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type)
  - [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type)
  - [Slack](https://www.elastic.co/docs/reference/kibana/connectors-kibana/slack-action-type)
  - [Swimlane](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type)
  - [Torq](https://www.elastic.co/docs/reference/kibana/connectors-kibana/torq-action-type)
  - [Webhook](https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type)
  - [xMatters](https://www.elastic.co/docs/reference/kibana/connectors-kibana/xmatters-action-type)

  <note>
    Some connector types are paid commercial features, while others are free. For a comparison of the Elastic subscription levels, go to [the subscription page](https://www.elastic.co/subscriptions).
  </note>
  For more information on creating connectors, refer to [Connectors](https://www.elastic.co/docs/deploy-manage/manage-connectors).
</dropdown>

<dropdown title="Action frequency">
  After you select a connector, you must set the action frequency. You can choose to create a **Summary of alerts** on each check interval or on a custom interval. For example, you can send email notifications that summarize the new, ongoing, and recovered alerts every twelve hours.Alternatively, you can set the action frequency to **For each alert** and specify the conditions each alert must meet for the action to run. For example, you can send an email only when alert status changes to critical.
  ![Configure when a rule is triggered](https://www.elastic.co/docs/solutions/images/serverless-alert-action-frequency.png)
  With the **Run when** menu you can choose if an action runs when the the anomaly score matched the condition or was recovered. For example, you can add a corresponding action for each state to ensure you are alerted when the anomaly score was matched and also when it recovers.
  ![Choose between anomaly score matched condition or recovered](https://www.elastic.co/docs/solutions/images/serverless-alert-anomaly-action-frequency-recovered.png)
</dropdown>

<dropdown title="Action variables">
  Use the default notification message or customize it. You can add more context to the message by clicking the Add variable icon ![Add variable](https://www.elastic.co/docs/solutions/images/serverless-indexOpen.svg) and selecting from a list of available variables.
  ![Action variables list](https://www.elastic.co/docs/solutions/images/serverless-action-variables-popup.png)
  The following variables are specific to this rule type. You can also specify [variables common to all rules](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/rule-action-variables).
  <definitions>
    <definition term="context.anomalyExplorerUrl">
      URL to open in the Anomaly Explorer.
    </definition>
    <definition term="context.isInterim">
      Indicate if top hits contain interim results.
    </definition>
    <definition term="context.jobIds">
      List of job IDs that triggered the alert.
    </definition>
    <definition term="context.message">
      Alert info message.
    </definition>
    <definition term="context.score">
      Anomaly score at the time of the notification action.
    </definition>
    <definition term="context.timestamp">
      The bucket timestamp of the anomaly.
    </definition>
    <definition term="context.timestampIso8601">
      The bucket timestamp of the anomaly in ISO8601 format.
    </definition>
    <definition term="context.topInfluencers">
      The list of top influencers. Properties include:
      `influencer_field_name`
    </definition>
    <definition term="The field name of the influencer.">
      `influencer_field_value`
    </definition>
    <definition term="The entity that influenced, contributed to, or was to blame for the anomaly.">
      `score`
    </definition>
    <definition term="The influencer score. A normalized score between 0-100 which shows the influencer’s overall contribution to the anomalies.">
    </definition>
    <definition term="context.topRecords">
      The list of top records. Properties include:
      `actual`
    </definition>
    <definition term="The actual value for the bucket.">
      `by_field_value`
    </definition>
    <definition term="The value of the by field.">
      `field_name`
    </definition>
    <definition term="Certain functions require a field to operate on, for example, sum(). For those functions, this value is the name of the field to be analyzed.">
      `function`
    </definition>
    <definition term="The function in which the anomaly occurs, as specified in the detector configuration. For example, max.">
      `over_field_name`
    </definition>
    <definition term="The field used to split the data.">
      `partition_field_value`
    </definition>
    <definition term="The field used to segment the analysis.">
      `score`
    </definition>
    <definition term="A normalized score between 0-100, which is based on the probability of the anomalousness of this record.">
      `typical`
    </definition>
    <definition term="The typical value for the bucket, according to analytical modeling.">
    </definition>
  </definitions>
</dropdown>


## Edit an anomaly detection rule

To edit an anomaly detection rule:
1. In your Elastic Observability Serverless project, go to **Machine learning** → **Jobs**.
2. Expand the job that uses the rule you want to edit.
3. On the **Job settings** tab, under **Alert rules**, click the rule to edit it.