﻿---
title: Create a failed docs rule
description: Create a failed docs rule using the custom threshold rule to alert when the number of failed documents in your data stream reaches or exceeds a given...
url: https://www.elastic.co/docs/solutions/observability/incident-management/create-a-failed-docs-rule
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.1
---

# Create a failed docs rule
<note>
  The **Editor** role or higher is required to create a failed docs rule using custom threshold rule. To learn more, refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles).
</note>

Create a failed docs rule using the [custom threshold rule](https://www.elastic.co/docs/solutions/observability/incident-management/create-custom-threshold-rule) to alert when the number of failed documents in your data stream reaches or exceeds a given value.
![Create failed docs rule using the custom threshold rule type](https://www.elastic.co/docs/solutions/images/failed-docs-rule.png)

When creating a failed docs rule, the process depends on your deployment type and your space's solution view. You can check your solution view by selecting the **Spaces** icon.
Select the appropriate tab for your setup, then follow the instructions to create a failed docs rule:
<tab-set>
  <tab-item title="Serverless and Observability solution view">
    1. From the main menu, open the **Data Set Quality** page from **Management** → **Stack Management**, or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
    2. Find the data set you want to create a rule for in the table, and select **Open** from the **Actions** column.
    3. Select **Alerts** → **Create custom threshold rule**.
    4. Select **Add aggregation/field**.
    5. For your new aggregation, set **Aggregation type** to **Count** and **KQL Filter** to `_index : ".fs*"`.
    6. Select **Equation**, and set the equation to `(B / A) * 100`.
    7. Set **Is above** to the desired threshold. For example, `1.5`.
    8. Set the **Label** to `Failed docs`.
    9. Select **Next** to go to the **Details** step.
    10. Set the **Rule name** to `Data set quality` and add `failed_docs` to the **Tags**.
    11. Select **Create rule**.
  </tab-item>

  <tab-item title="Classic solution view">
    1. Select **Manage rules and connectors**.
    2. Select **Create rule**, then **Custom threshold**.
    3. Select **Data view**, then **Create a data view**.
    4. Find your data stream under **All sources**.
    5. Name your data view.
    6. Add your index pattern with `::failures` appended. For example, `logs-synth.2-default::data,logs-synth.2-default::failures`.
    7. Select **Save data view to Kibana**.
    8. Select **Add aggregation/field**.
    9. For your new aggregation, set **Aggregation type** to **Count** and **KQL Filter** to `_index : ".fs*"`.
    10. Select **Equation**, and set the equation to `(B / A) * 100`.
    11. Set **Is above** to the desired threshold. For example, `1.5`.
    12. Set the **Label** to `Failed docs`.
    13. Select **Next** to go to the **Details** menu.
    14. Set the **Rule name** to `Data set quality` and add `failed_docs` to the **Tags**.
    15. Select **Create rule**.
  </tab-item>
</tab-set>


## Add actions

You can extend your rules with actions that interact with third-party systems, write to logs or indices, or send user notifications. You can add an action to a rule at any time. You can create rules without adding actions, and you can also define multiple actions for a single rule.
To add actions to rules, you must first create a connector for that service (for example, an email or external incident management system), which you can then use for different rules, each with their own action frequency.
<dropdown title="Connector types">
  Connectors provide a central place to store connection information for services and integrations with third party systems. The following connectors are available when defining actions for alerting rules:
  - [Cases](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-action-type)
  - [D3 Security](https://www.elastic.co/docs/reference/kibana/connectors-kibana/d3security-action-type)
  - [Email](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type)
  - [IBM Resilient](https://www.elastic.co/docs/reference/kibana/connectors-kibana/resilient-action-type)
  - [Index](https://www.elastic.co/docs/reference/kibana/connectors-kibana/index-action-type)
  - [Jira](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jira-action-type)
  - [Microsoft Teams](https://www.elastic.co/docs/reference/kibana/connectors-kibana/teams-action-type)
  - [Observability AI Assistant](https://www.elastic.co/docs/reference/kibana/connectors-kibana/obs-ai-assistant-action-type)
  - [Opsgenie](https://www.elastic.co/docs/reference/kibana/connectors-kibana/opsgenie-action-type)
  - [PagerDuty](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pagerduty-action-type)
  - [Server log](https://www.elastic.co/docs/reference/kibana/connectors-kibana/server-log-action-type)
  - [ServiceNow ITOM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type)
  - [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type)
  - [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type)
  - [Slack](https://www.elastic.co/docs/reference/kibana/connectors-kibana/slack-action-type)
  - [Swimlane](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type)
  - [Torq](https://www.elastic.co/docs/reference/kibana/connectors-kibana/torq-action-type)
  - [Webhook](https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type)
  - [xMatters](https://www.elastic.co/docs/reference/kibana/connectors-kibana/xmatters-action-type)

  <note>
    Some connector types are paid commercial features, while others are free. For a comparison of the Elastic subscription levels, go to [the subscription page](https://www.elastic.co/subscriptions).
  </note>
  For more information on creating connectors, refer to [Connectors](https://www.elastic.co/docs/deploy-manage/manage-connectors).
</dropdown>

<dropdown title="Action frequency">
  After you select a connector, you must set the action frequency. You can choose to create a summary of alerts on each check interval or on a custom interval. Alternatively, you can set the action frequency such that you choose how often the action runs (for example, at each check interval, only when the alert status changes, or at a custom action interval). In this case, you must also select the specific threshold condition that affects when actions run: `Alert`, `No Data`, or `Recovered`.
  ![Configure when a rule is triggered](https://www.elastic.co/docs/solutions/images/serverless-custom-threshold-run-when.png)
  You can also further refine the conditions under which actions run by specifying that actions only run when they match a KQL query or when an alert occurs within a specific time frame:
  - **If alert matches query**: Enter a KQL query that defines field-value pairs or query conditions that must be met for notifications to send. The query only searches alert documents in the indices specified for the rule.
  - **If alert is generated during timeframe**: Set timeframe details. Notifications are only sent if alerts are generated within the timeframe you define.

  ![Configure a conditional alert](https://www.elastic.co/docs/solutions/images/serverless-logs-threshold-conditional-alert.png)
</dropdown>

<dropdown title="Action variables">
  Use the default notification message or customize it. You can add more context to the message by clicking the Add variable icon ![Add variable](https://www.elastic.co/docs/solutions/images/serverless-indexOpen.svg) and selecting from a list of available variables.
  ![Action variables list](https://www.elastic.co/docs/solutions/images/serverless-action-variables-popup.png)
  The following variables are specific to this rule type. You can also specify [variables common to all rules](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/rule-action-variables).
  <definitions>
    <definition term="context.alertDetailsUrl">
      Link to the alert troubleshooting view for further context and details. This will be an empty string if the `server.publicBaseUrl` is not configured.
    </definition>
    <definition term="context.cloud">
      The cloud object defined by ECS if available in the source.
    </definition>
    <definition term="context.container">
      The container object defined by ECS if available in the source.
    </definition>
    <definition term="context.group">
      The array of objects containing groups that are reporting data.
    </definition>
    <definition term="context.grouping Elastic Stack: Generally available since 9.1">
      The object containing groups that are reporting data.
    </definition>
    <definition term="context.host">
      The host object defined by ECS if available in the source.
    </definition>
    <definition term="context.labels">
      List of labels associated with the entity where this alert triggered.
    </definition>
    <definition term="context.orchestrator">
      The orchestrator object defined by ECS if available in the source.
    </definition>
    <definition term="context.reason">
      A concise description of the reason for the alert.
    </definition>
    <definition term="context.tags">
      List of tags associated with the entity where this alert triggered.
    </definition>
    <definition term="context.timestamp">
      A timestamp of when the alert was detected.
    </definition>
    <definition term="context.value">
      List of the condition values.
    </definition>
    <definition term="context.viewInAppUrl">
      Link to the alert source.
    </definition>
  </definitions>
</dropdown>