﻿---
title: Create a degraded docs rule
description: Based on the data found on the Data Set Quality page, you can create a rule to notify you when the percentage of degraded documents for a specific data...
url: https://www.elastic.co/docs/solutions/observability/incident-management/create-a-degraded-docs-rule
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.1
---

# Create a degraded docs rule
<note>
  Users need the **Data Set Quality** role with the **Manage rules** privilege or the **Editor** role or higher to create degraded docs rules. To learn more, refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/manage-users#general-assign-user-roles).
</note>

Based on the data found on the [**Data Set Quality**](https://www.elastic.co/docs/solutions/observability/data-set-quality-monitoring) page, you can create a rule to notify you when the percentage of degraded documents for a specific data view has exceeded a value over a specific time period.
![Create rule for degraded docs](https://www.elastic.co/docs/solutions/images/observability-degraded-docs-rule.png)

To access this rule from the **Alerts** page:
1. Go to **Alerts**.
2. Click **Manage Rules** → **Create rule**.
3. Under **Select rule type**, select **Degraded docs**.

You can also access this rule from the **Data Set Quality** page:
1. To open the **Data Set Quality** management page, find it in the navigation menu or by using the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Select a data set name from the data set table.
3. Select **Actions** in the upper-right corner of the page.
4. Select **Create rule**.


## Define the conditions

Define the following conditions for your rule:
1. Set the data view you want to create the rule for. If you access the rule from the **Data Set Quality** page, the data view is automatically populated.
2. Set the threshold percentage that, when exceeded for a period of time, the rule sends an alert.
3. Specify how long the threshold must be exceeded before an alert is sent.
4. (Optional) Set one or more **Group alerts by** fields. Every unique value will create an alert.
5. Set how often to check the rule conditions by selecting a time value and unit under **Rule schedule**.
6. (Optional) Configure **Advanced options**:
   - Define the number of consecutive matches required before an alert is triggered under **Alert delay**.
- Enable or disable **Flapping Detection** to reduce noise from frequently changing alerts. You can customize the flapping detection settings if you need different thresholds for detecting flapping behavior.


## Preview chart

The preview chart provides a visualization of how many entries match your configuration. The shaded area shows the threshold you’ve set.
If you use the **Group alerts by** option, the maximum bar size will be 3. It will only show the top 3 fields.

## Add actions

You can extend your rules with actions that interact with third-party systems, write to logs or indices, or send user notifications. You can add an action to a rule at any time. You can create rules without adding actions, and you can also define multiple actions for a single rule.
To add actions to rules, you must first create a connector for that service (for example, an email or external incident management system), which you can then use for different rules, each with their own action frequency.
<dropdown title="Connector types">
  Connectors provide a central place to store connection information for services and integrations with third party systems. The following connectors are available when defining actions for alerting rules:
  - [Cases](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-action-type)
  - [D3 Security](https://www.elastic.co/docs/reference/kibana/connectors-kibana/d3security-action-type)
  - [Email](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type)
  - [IBM Resilient](https://www.elastic.co/docs/reference/kibana/connectors-kibana/resilient-action-type)
  - [Index](https://www.elastic.co/docs/reference/kibana/connectors-kibana/index-action-type)
  - [Jira](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jira-action-type)
  - [Microsoft Teams](https://www.elastic.co/docs/reference/kibana/connectors-kibana/teams-action-type)
  - [Observability AI Assistant](https://www.elastic.co/docs/reference/kibana/connectors-kibana/obs-ai-assistant-action-type)
  - [Opsgenie](https://www.elastic.co/docs/reference/kibana/connectors-kibana/opsgenie-action-type)
  - [PagerDuty](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pagerduty-action-type)
  - [Server log](https://www.elastic.co/docs/reference/kibana/connectors-kibana/server-log-action-type)
  - [ServiceNow ITOM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type)
  - [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type)
  - [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type)
  - [Slack](https://www.elastic.co/docs/reference/kibana/connectors-kibana/slack-action-type)
  - [Swimlane](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type)
  - [Torq](https://www.elastic.co/docs/reference/kibana/connectors-kibana/torq-action-type)
  - [Webhook](https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type)
  - [xMatters](https://www.elastic.co/docs/reference/kibana/connectors-kibana/xmatters-action-type)

  <note>
    Some connector types are paid commercial features, while others are free. For a comparison of the Elastic subscription levels, go to [the subscription page](https://www.elastic.co/subscriptions).
  </note>
  For more information on creating connectors, refer to [Connectors](https://www.elastic.co/docs/deploy-manage/manage-connectors).
</dropdown>

<dropdown title="Action frequency">
  After you select a connector, you must set the action frequency. You can choose to create a summary of alerts on each check interval or on a custom interval. Alternatively, you can set the action frequency such that you choose how often the action runs (for example, at each check interval, only when the alert status changes, or at a custom action interval). In this case, you must also select the specific threshold condition that affects when actions run: `Alert`, `No Data`, or `Recovered`.
  ![Configure when a rule is triggered](https://www.elastic.co/docs/solutions/images/serverless-custom-threshold-run-when.png)
  You can also further refine the conditions under which actions run by specifying that actions only run when they match a KQL query or when an alert occurs within a specific time frame:
  - **If alert matches query**: Enter a KQL query that defines field-value pairs or query conditions that must be met for notifications to send. The query only searches alert documents in the indices specified for the rule.
  - **If alert is generated during timeframe**: Set timeframe details. Notifications are only sent if alerts are generated within the timeframe you define.

  ![Configure a conditional alert](https://www.elastic.co/docs/solutions/images/serverless-logs-threshold-conditional-alert.png)
</dropdown>

<dropdown title="Action variables">
  Use the default notification message or customize it. You can add more context to the message by clicking the Add variable icon ![Add variable](https://www.elastic.co/docs/solutions/images/serverless-indexOpen.svg) and selecting from a list of available variables.
  ![Action variables list](https://www.elastic.co/docs/solutions/images/serverless-action-variables-popup.png)
  The following variables are specific to this rule type. You can also specify [variables common to all rules](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/rule-action-variables).
  <definitions>
    <definition term="context.alertDetailsUrl">
      Link to the alert troubleshooting view for further context and details. This will be an empty string if the `server.publicBaseUrl` is not configured.
    </definition>
    <definition term="context.cloud">
      The cloud object defined by ECS if available in the source.
    </definition>
    <definition term="context.container">
      The container object defined by ECS if available in the source.
    </definition>
    <definition term="context.group">
      The object containing groups that are reporting data.
    </definition>
    <definition term="context.host">
      The host object defined by ECS if available in the source.
    </definition>
    <definition term="context.labels">
      List of labels associated with the entity where this alert triggered.
    </definition>
    <definition term="context.orchestrator">
      The orchestrator object defined by ECS if available in the source.
    </definition>
    <definition term="context.reason">
      A concise description of the reason for the alert.
    </definition>
    <definition term="context.tags">
      List of tags associated with the entity where this alert triggered.
    </definition>
    <definition term="context.timestamp">
      A timestamp of when the alert was detected.
    </definition>
    <definition term="context.value">
      List of the condition values.
    </definition>
    <definition term="context.viewInAppUrl">
      Link to the alert source.
    </definition>
  </definitions>
</dropdown>