﻿---
title: Configure access to cases in Elastic Observability
description: To access and send cases to external systems, you need the appropriate license, and your role must have the Cases Kibana privilege as a user for the Observability...
url: https://www.elastic.co/docs/solutions/observability/incident-management/configure-access-to-cases
products:
  - Elastic Observability
---

# Configure access to cases in Elastic Observability
To access and send cases to external systems, you need the [appropriate license](https://www.elastic.co/subscriptions), and your role must have the **Cases** Kibana privilege as a user for the **Observability** feature.
<note>
  If you are using an on-premises Kibana deployment and want your email notifications and external incident management systems to contain links back to Kibana, configure the [server.publicBaseUrl](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings#server-publicbaseurl) setting.
</note>

For more details, refer to [feature access based on user privileges](/docs/deploy-manage/manage-spaces#spaces-control-user-access).
![cases privileges](https://www.elastic.co/docs/solutions/images/observability-cases-privileges.png)

Below are the minimum required privileges for some common use cases.

## Give full access to manage cases and settings

- `All` for the **Cases** feature under **Observability**.
- `All` for the **Actions and Connectors** feature under **Management**.
  <note>
  Roles without `All` **Actions and Connectors** feature privileges cannot create, add, delete, or modify case connectors.By default, `All` for the **Cases** feature allows you to have full control over cases, including deleting them, editing case settings, and more. You can customize the sub-feature privileges to limit feature access.
  </note>


## Give assignee access to cases

- `All` for the **Cases** feature under **Observability**.
  <note>
  Before a user can be assigned to a case, they must log into Kibana at least once, which creates a user profile.
  </note>


## Give view-only access for cases

- `Read` for the **Cases** feature under **Observability**.
  <note>
  You can customize sub-feature privileges for deleting cases, deleting alerts and comments from cases, editing case settings, adding case comments and attachements, and re-opening cases.
  </note>


## Give access to add alerts to cases

- `All` for the **Cases** feature under **Observability**.
- `Read` for an **Observability** feature that has alerts.


## Revoke all access to cases

- `None` for the **Cases** feature under **Observability**.