﻿---
title: Cases for Elastic Observability
description: Collect and share information about observability issues by creating a case. Cases allow you to track key investigation details, add assignees and tags...
url: https://www.elastic.co/docs/solutions/observability/incident-management/cases
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Cases for Elastic Observability
Collect and share information about observability issues by creating a case. Cases allow you to track key investigation details, add assignees and tags to your cases, set their severity and status, and add alerts, comments, and visualizations. You can also send cases to third-party systems by [configuring external connectors](https://www.elastic.co/docs/solutions/observability/incident-management/configure-case-settings).
<applies-to>Elastic Stack: Generally available since 9.2</applies-to> Cases are automatically assigned human-readable numeric IDs, which you can use for easier referencing. Each time you create a new case in your [space](https://www.elastic.co/docs/deploy-manage/manage-spaces), the case ID increments by one. IDs are assigned to cases by a background task that runs every 10 minutes, which can cause a delay in ID assignment, especially in spaces with many cases. You can find the case ID after the case's name and can use it while searching the Cases table.
![Cases page](https://www.elastic.co/docs/solutions/images/observability-cases.png)

<tip applies-to="Elastic Cloud Serverless: Unavailable, Elastic Stack: Preview since 9.2">
  After creating cases, use case data to build dashboards and visualizations that provide insights into case trends and operational metrics. Refer to [Use cases as data](https://www.elastic.co/docs/explore-analyze/alerts-cases/cases/cases-as-data) to learn more.
</tip>


## Limitations

- If you create cases in Observability, they are not visible from the Elastic Security app or Stack Management. Likewise, the cases you create in Stack Management are not visible in the Observability or Elastic Security.
- You cannot attach alerts from Elastic Security or Stack Management to cases in Observability.