﻿---
title: Elastic Observability quickstarts
description: Our quickstarts reduce your time-to-value by offering a fast path to ingest and visualize your Observability data. Each quickstart provides: A highly...
url: https://www.elastic.co/docs/solutions/observability/get-started/quickstarts
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Observability quickstarts
Our quickstarts reduce your time-to-value by offering a fast path to ingest and visualize your Observability data. Each quickstart provides:
- A highly opinionated, fast path to data ingestion
- Sensible configuration defaults with minimal configuration required
- Auto-detection of logs and metrics for monitoring hosts
- Quick access to related dashboards and visualizations

Follow the steps in these guides to get started quickly:
- [**Quickstart: Monitor hosts with OpenTelemetry**](https://www.elastic.co/docs/solutions/observability/get-started/quickstart-monitor-hosts-with-opentelemetry).
- [**Quickstart: Monitor your application performance**](https://www.elastic.co/docs/solutions/observability/get-started/quickstart-monitor-your-application-performance).
- [**Quickstart: Monitor Kubernetes with OpenTelemetry**](https://www.elastic.co/docs/solutions/observability/get-started/quickstart-unified-kubernetes-observability-with-elastic-distributions-of-opentelemetry-edot).
- [**Quickstart: Send data to the Elastic Cloud Managed OTLP Endpoint**](https://www.elastic.co/docs/solutions/observability/get-started/quickstart-elastic-cloud-otel-endpoint).
- [**Quickstart: Create a Synthetic monitor**](https://www.elastic.co/docs/solutions/observability/get-started/quickstart-create-synthetic-monitor).
- [**Quickstart: Collect data from AWS Firehose**](https://www.elastic.co/docs/solutions/observability/get-started/quickstart-collect-data-with-aws-firehose).


## Get started with other features

Want to use Fleet or some other feature not covered in the quickstarts? Follow the steps in these guides to get started:
- [Get started with system metrics](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/get-started-with-system-metrics).
- [Get started with synthetic monitoring](https://www.elastic.co/docs/solutions/observability/synthetics).
- [Get started with Universal Profiling](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/get-started-with-universal-profiling).


## Additional guides

Ready to dig into more features of Elastic Observability? See these guides:
- [Create an alert](https://www.elastic.co/docs/solutions/observability/incident-management/alerting).
- [Create a service-level objective (SLO)](https://www.elastic.co/docs/solutions/observability/incident-management/create-an-slo).


## Related content for Elastic Stack

- [Starting with the Elasticsearch Platform and its Solutions](https://www.elastic.co/docs/get-started) for new users.
- [Adding data to Elasticsearch](https://www.elastic.co/docs/manage-data/ingest) for other ways to ingest data.