﻿---
title: Quickstart: Unified Kubernetes Observability with Elastic Distributions of OpenTelemetry (EDOT)
description: Learn how to send Kubernetes logs, metrics, and application traces to Elasticsearch using the OpenTelemetry Operator and Elastic Distributions of OpenTelemetry (EDOT).
url: https://www.elastic.co/docs/solutions/observability/get-started/quickstart-unified-kubernetes-observability-with-elastic-distributions-of-opentelemetry-edot
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Quickstart: Unified Kubernetes Observability with Elastic Distributions of OpenTelemetry (EDOT)
In this quickstart guide, you’ll learn how to send Kubernetes logs, metrics, and application traces to Elasticsearch, using the [OpenTelemetry Operator](https://github.com/open-telemetry/opentelemetry-operator/) to orchestrate [Elastic Distributions of OpenTelemetry](https://www.elastic.co/docs/reference/opentelemetry) (EDOT) Collectors and SDK instances.
All the components are deployed through the [opentelemetry-kube-stack](https://github.com/open-telemetry/opentelemetry-helm-charts/tree/main/charts/opentelemetry-kube-stack) helm chart. They include:
- [OpenTelemetry Operator](https://github.com/open-telemetry/opentelemetry-operator/).
- `DaemonSet` EDOT Collector configured for node level metrics.
- `Deployment` EDOT Collector configured for cluster level metrics.
- `Instrumentation` object for applications [auto-instrumentation](https://opentelemetry.io/docs/kubernetes/operator/automatic/).

For a more detailed description of the components and advanced configuration, refer to [elastic/opentelemetry](https://www.elastic.co/docs/reference/opentelemetry).

## Prerequisites

<applies-switch>
  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    - An Elastic Observability Serverless project. To learn more, refer to [Create an Observability project](https://www.elastic.co/docs/solutions/observability/get-started).
    - A running Kubernetes cluster (v1.23 or later).
    - [Kubectl](https://kubernetes.io/docs/reference/kubectl/).
    - Helm version 3.9+ up to and including 3.19.5.
    - (optional) [Cert-manager](https://cert-manager.io/docs/installation/), if you opt for automatic generation and renewal of TLS certificates.
  </applies-item>

  <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
    - An Elasticsearch cluster for storing and searching your data, and Kibana for visualizing and managing your data. This quickstart is available for all Elastic deployment models. To get started quickly, try out [Elastic Cloud](https://cloud.elastic.co/registration?page=docs&placement=docs-body).
    - A running Kubernetes cluster (v1.23 or later).
    - [Kubectl](https://kubernetes.io/docs/reference/kubectl/).
    - Helm version 3.9+ up to and including 3.19.5.
    - (optional) [Cert-manager](https://cert-manager.io/docs/installation/), if you opt for automatic generation and renewal of TLS certificates.
  </applies-item>
</applies-switch>


## Collect your data

<applies-switch>
  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    1. [Create a new Elastic Observability Serverless project](https://www.elastic.co/docs/solutions/observability/get-started), or open an existing one.
    2. In your Elastic Observability Serverless project, go to **Add Data**.
    3. Under **What do you want to monitor?** select **Kubernetes**, and then select **OpenTelemetry: Full Observability**.
       ![](https://www.elastic.co/docs/solutions/images/serverless-quickstart-k8s-otel-entry-point.png)

    1. Follow the on-screen instructions to install all needed components.
       <note>
       The default installation deploys the OpenTelemetry Operator with a self-signed TLS certificate valid for 365 days. This certificate **won’t be renewed** unless the Helm Chart release is manually updated. Refer to the [cert-manager integrated installation](/docs/solutions/observability/get-started/opentelemetry/use-cases/kubernetes/customization#cert-manager-integrated-installation) guide to enable automatic certificate generation and renewal using [cert-manager](https://cert-manager.io/docs/installation/).
       </note>
       Deploy the OpenTelemetry Operator and EDOT Collectors using the kube-stack Helm chart with the provided `values.yaml` file. You will run a few commands to:
       - Add the helm chart repository needed for the installation.
    - Create a namespace.
    - Create a secret with an API Key and the Elasticsearch endpoint to be used by the collectors.
    - Install the `opentelemetry-kube-stack` helm chart with the provided `values.yaml`.
    - Optionally, for instrumenting applications, apply the corresponding `annotations` as shown in Kibana.
  </applies-item>

  <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
    1. In Kibana, go to the **Observability** UI and click **Add Data**.
    2. Under **What do you want to monitor?** select **Kubernetes**, and then select **OpenTelemetry: Full Observability**.
       ![](https://www.elastic.co/docs/solutions/images/observability-quickstart-k8s-otel-entry-point.png)

    1. Follow the on-screen instructions to install all needed components.
       <note>
       The default installation deploys the OpenTelemetry Operator with a self-signed TLS certificate valid for 365 days. This certificate **won’t be renewed** unless the Helm Chart release is manually updated. Refer to the [cert-manager integrated installation](/docs/solutions/observability/get-started/opentelemetry/use-cases/kubernetes/customization#cert-manager-integrated-installation) guide to enable automatic certificate generation and renewal using [cert-manager](https://cert-manager.io/docs/installation/).
       </note>
       Deploy the OpenTelemetry Operator and EDOT Collectors using the kube-stack Helm chart with the provided `values.yaml` file. You will run a few commands to:
       - Add the helm chart repository needed for the installation.
    - Create a namespace.
    - Create a secret with an API Key and the Elasticsearch endpoint to be used by the collectors.
    - Install the `opentelemetry-kube-stack` helm chart with the provided `values.yaml`.
    - Optionally, for instrumenting applications, apply the corresponding `annotations` as shown in Kibana.
  </applies-item>
</applies-switch>


## Visualize your data

After installation is complete and all relevant data is flowing into Elastic, the **Visualize your data** section provides a link to the **OTEL][Metrics Kubernetes]Cluster Overview** dashboard used to monitor the health of the cluster.
![Kubernetes overview dashboard](https://www.elastic.co/docs/solutions/images/observability-quickstart-k8s-otel-dashboard.png)


### Work with Kubernetes logs

You can search and analyze Kubernetes logs using Elastic’s Discover capability. Find **Discover** in the main menu or use the global search field.
![Kubernetes logs in Discover](https://www.elastic.co/docs/solutions/images/screenshot-observability-monitoring-k8s-kubernetes-logs-can-be-searched.png)


### Visualize Kubernetes metrics

Kubernetes out-of-the-box dashboards allow you to analyze Kubernetes metrics within Kibana. Go to **Dashboards** → **Analytics** and search for **Kubernetes**. The **Kubernetes Overview** dashboard shows metrics for the entire Kubernetes Cluster. All the nodes, pods, and CPU and memory usage.
![Kubernetes overview dashboard](https://www.elastic.co/docs/solutions/images/screenshot-observability-monitoring-k8s-kubernetes-overview-cluster.png)

Kibana allows you to analyze logs with interactive dashboards to derive insights, automate workflows, find anomalies and trends, and more. When you select **Dashboards** → **Analytics**, you can select **Create dashboard** and customize your new dashboard to your needs.

### Set up alerts

Select **Alerts** and then **Create rules**. This allows you to get notifications when various events happen, for example when latency is anomalous, metric aggregation exceeds threshold, and so on. Notifications are sent through email, Jira, Slack, and more.

### Use machine learning to uncover insights

Find **Machine Learning** in the main menu or use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). Then select **Anomaly Detection** → **Jobs** to create a machine learning job. By setting up machine learning jobs, for example, rather than having an alert when a specific percentage of memory usage has occurred, you can know when the usage is unusual.
![Machine learning job](https://www.elastic.co/docs/solutions/images/screenshot-observability-monitoring-k8s-leverage-machine-learning-to-uncover-insights.png)


## Troubleshooting and more

- To troubleshoot deployment and installation, refer to [installation verification](/docs/solutions/observability/get-started/opentelemetry/use-cases/kubernetes/deployment#verify-the-installation).
- For application instrumentation details, refer to [Instrumenting applications with EDOT SDKs on Kubernetes](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/use-cases/kubernetes/instrumenting-applications).
- To customize the configuration, refer to [custom configuration](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/use-cases/kubernetes/customization).
- Refer to [Observability overview](https://www.elastic.co/docs/solutions/observability) for a description of other useful features.