﻿---
title: Quickstart: Monitor your application performance
description: Learn how to monitor your application performance using the Elastic Distribution of OpenTelemetry (EDOT) SDKs and Elastic APM.
url: https://www.elastic.co/docs/solutions/observability/get-started/quickstart-monitor-your-application-performance
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Quickstart: Monitor your application performance
In this quickstart guide, you’ll learn how to instrument your application using the Elastic Distribution of OpenTelemetry (EDOT) SDKs. You’ll also learn how to use Observability features to gain deeper insight into your application telemetry data after collecting it.

## Prerequisites

<applies-switch>
  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    - An Observability project. To learn more, refer to [Create an Observability project](https://www.elastic.co/docs/solutions/observability/get-started).
    - A user with the **Admin** role or higher—required to onboard system logs and metrics. To learn more, refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles).
    - An Elastic Distribution of OpenTelemetry (EDOT) Collector or the contrib OpenTelemetry Collector running on the host.
    - An APM agent key for authenticating your EDOT SDKs. To create one, refer to [Create APM agent key for EDOT SDKs](https://www.elastic.co/docs/solutions/observability/apm/opentelemetry/create-apm-agent-key-for-edot-sdks).
  </applies-item>

  <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
    - An Observability project. To learn more, refer to [Create an Observability project](https://www.elastic.co/docs/solutions/observability/get-started).
    - A user with the **Admin** role or higher—required to onboard system logs and metrics. To learn more, refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles).
    - An Elastic Distribution of OpenTelemetry (EDOT) Collector or the contrib OpenTelemetry Collector running on the host.
    - An APM agent key for authenticating your EDOT SDKs. To create one, refer to [Create APM agent key for EDOT SDKs](https://www.elastic.co/docs/solutions/observability/apm/opentelemetry/create-apm-agent-key-for-edot-sdks).
  </applies-item>
</applies-switch>


## Install the EDOT Collector

The EDOT Collector in [Agent mode](https://www.elastic.co/docs/reference/edot-collector/modes#edot-collector-as-agent) collects infrastructure and application telemetry data sent by the EDOT SDKs and forwards it to Elastic.
Refer to the [EDOT Quickstarts](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart) to install the EDOT Collector for your deployment mode.

## Collect application telemetry data

Follow these steps to collect application telemetry data using the EDOT SDKs:
<applies-switch>
  <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
    1. In Kibana, go to the **Observability** UI and click **Add Data**.
    2. Under **What do you want to monitor?** select **Application**, and then select **OpenTelemetry**.
    3. Follow the instructions to install the EDOT SDK for your application:
       - [Android](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android)
    - [.NET](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/dotnet/setup)
    - [iOS](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/ios)
    - [Java](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/java/setup)
    - [Node.js](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/node/setup)
    - [PHP](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/php/setup)
    - [Python](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python/setup)
    4. Configure your EDOT SDK to send data to the APM endpoint. The **OpenTelemetry** tab provides the required configuration values.

    <note>
      If your application runs on Kubernetes, the OpenTelemetry operator automatically instruments your application, provided you've added language-specific annotations. Refer to [Auto-instrument applications](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/self-managed/k8s).
    </note>
  </applies-item>

  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    1. [Create a new Elastic Observability Serverless project](https://www.elastic.co/docs/solutions/observability/get-started), or open an existing one.
    2. Under **What do you want to monitor?** select **Application**, and then select **OpenTelemetry**.
    3. Follow the instructions to install the EDOT SDK for your application:
       - [Android](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/android)
    - [.NET](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/dotnet/setup)
    - [iOS](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/ios)
    - [Java](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/java/setup)
    - [Node.js](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/node/setup)
    - [PHP](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/php/setup)
    - [Python](https://www.elastic.co/docs/reference/opentelemetry/edot-sdks/python/setup)
    4. Configure your EDOT SDK to send data to the [Managed OTLP endpoint](https://www.elastic.co/docs/reference/opentelemetry/motlp). The **OpenTelemetry** tab provides the required configuration values.
    5. (Optional) Activate Central Configuration to configure your EDOT SDKs from within Kibana. Refer to [EDOT SDKs Central Configuration](https://www.elastic.co/docs/reference/opentelemetry/central-configuration).

    <note>
      If your application runs on Kubernetes, the OpenTelemetry operator automatically instruments your application, provided you've added language-specific annotations. Refer to [Auto-instrument applications](https://www.elastic.co/docs/solutions/observability/get-started/opentelemetry/quickstart/serverless/k8s).
    </note>
  </applies-item>
</applies-switch>


## Gain deeper insight into your application data

After using the **Applications** page and **Discover** to confirm you’ve ingested all the application traces, metrics, and logs you want to monitor, use Elastic Observability to gain deeper insight into your application data with the following capabilities and features:
- In the [Applications UI](https://www.elastic.co/docs/solutions/observability/apm/view-analyze-data), analyze and compare data collected from your application. You can also:
  - [Drill down into data](https://www.elastic.co/docs/solutions/observability/apm/drill-down-into-data) to view details about specific transactions and spans.
- [Find transaction latency and failure correlations](https://www.elastic.co/docs/solutions/observability/apm/find-transaction-latency-failure-correlations) to identify root causes.
- [Create alerts](https://www.elastic.co/docs/solutions/observability/apm/create-apm-rules-alerts) that notify you when an anomaly is detected or a metric exceeds a given value.
- In [Service Map](https://www.elastic.co/docs/solutions/observability/apm/service-map), explore how your services are connected and check health indicators. You can also:
- Use [machine learning](https://www.elastic.co/docs/solutions/observability/apm/machine-learning) to quickly pinpoint anomalous transactions and see the health of any contrib and downstream services.

Refer to the [Elastic Observability](https://www.elastic.co/docs/solutions/observability) for a description of other useful features.