﻿---
title: Quickstart: Monitor your Kubernetes cluster with Elastic Agent
description: Learn how to monitor your Kubernetes cluster infrastructure with minimal configuration using Elastic Agent and kubectl commands.
url: https://www.elastic.co/docs/solutions/observability/get-started/quickstart-monitor-kubernetes-cluster-with-elastic-agent
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Quickstart: Monitor your Kubernetes cluster with Elastic Agent
In this quickstart guide, you'll learn how to create the Kubernetes resources required to monitor your cluster infrastructure by using a single command to download, install, and configure Elastic Agent in your Kubernetes cluster.
<tip>
  We recommend using the [Elastic Distribution of OpenTelemetry (EDOT) Collector](https://www.elastic.co/docs/solutions/observability/get-started/quickstart-unified-kubernetes-observability-with-elastic-distributions-of-opentelemetry-edot) as the preferred way to collect Kubernetes logs, metrics, and application traces using OpenTelemetry.
</tip>

<note>
  In Elastic Stack versions 9.0 and 9.1, the quickstart uses [Kubectl](https://kubernetes.io/docs/reference/kubectl/) to install Elastic Agent in a Kubernetes cluster. However, these versions also support using [Helm](https://helm.sh/docs/) charts, which is now the preferred method for installing Elastic Agent on Kubernetes. If your cluster is on version 9.0 or 9.1, we recommend that you follow the [Install Elastic Agent on Kubernetes using Helm](https://www.elastic.co/docs/reference/fleet/install-on-kubernetes-using-helm) guide to deploy Elastic Agent.
</note>


## Prerequisites

<applies-switch>
  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    - An Elastic Observability Serverless project. To learn more, refer to [Create an Observability project](https://www.elastic.co/docs/solutions/observability/get-started).
    - A user with the **Admin** role or higher (required to onboard system logs and metrics). To learn more, refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles).
    - A running Kubernetes cluster with internet access
    - Helm version 3.9+ up to and including 3.19.5.
  </applies-item>

  <applies-item title="stack: ga 9.2+" applies-to="Elastic Stack: Generally available since 9.2">
    - A running Elastic Stack deployment, either self-managed or orchestrated by platforms like Elastic Cloud Hosted, Elastic Cloud Enterprise, or Elastic Cloud on Kubernetes, with internet access. To get started quickly, try out [Elastic Cloud](https://cloud.elastic.co/registration?page=docs&placement=docs-body).
    - A user with the `superuser` [built-in role](https://www.elastic.co/docs/reference/elasticsearch/roles) or the privileges required to onboard data.

    <dropdown title="Expand to view required privileges">
      - [**Cluster**](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-cluster): `['monitor', 'manage_own_api_key']`
      - [**Index**](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-indices): `{ names: ['logs-*-*', 'metrics-*-*'], privileges: ['auto_configure', 'create_doc'] }`
      - [**Kibana**](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges): `{ spaces: ['*'], feature: { fleet: ['all'], fleetv2: ['all'] } }`
    </dropdown>

    - A running Kubernetes cluster with internet access
    - Helm version 3.9+ up to and including 3.19.5.
  </applies-item>

  <applies-item title="stack: ga 9.0-9.1" applies-to="Elastic Stack: Generally available from 9.0 to 9.1">
    - A running Elastic Stack deployment, either self-managed or orchestrated by platforms like Elastic Cloud Hosted, Elastic Cloud Enterprise, or Elastic Cloud on Kubernetes, with internet access. To get started quickly, try out [Elastic Cloud](https://cloud.elastic.co/registration?page=docs&placement=docs-body).
    - A user with the `superuser` [built-in role](https://www.elastic.co/docs/reference/elasticsearch/roles) or the privileges required to onboard data.

    <dropdown title="Expand to view required privileges">
      - [**Cluster**](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-cluster): `['monitor', 'manage_own_api_key']`
      - [**Index**](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-indices): `{ names: ['logs-*-*', 'metrics-*-*'], privileges: ['auto_configure', 'create_doc'] }`
      - [**Kibana**](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges): `{ spaces: ['*'], feature: { fleet: ['all'], fleetv2: ['all'] } }`
    </dropdown>

    - A running Kubernetes cluster with internet access
    - [Kubectl](https://kubernetes.io/docs/reference/kubectl/) or Helm version 3.9+ up to and including 3.19.5
  </applies-item>
</applies-switch>


## Limitations

The installation command provided by the UI during the quickstart cannot be used as-is to install Elastic Agent in an air-gapped environment. For an air-gapped environment with a self-managed Elastic Stack deployment or orchestrator such as [Elastic Cloud on Kubernetes](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s), refer to the following resources:
- [Install Elastic Agent air-gapped](/docs/deploy-manage/deploy/self-managed/air-gapped-install#air-gapped-elastic-agent)
- [Install Elastic Agent on Kubernetes using Helm](https://www.elastic.co/docs/reference/fleet/install-on-kubernetes-using-helm)
- [Deploy Elastic Agent in standalone mode with ECK](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/standalone-elastic-agent)
- [Run Elastic Agent in an air-gapped environment](https://www.elastic.co/docs/reference/fleet/air-gapped)


## Collect your data

<applies-switch>
  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    1. Go to your [Elastic Observability Serverless](https://www.elastic.co/docs/solutions/observability/get-started) project, then go to **Add data**.
    2. In the **What do you want to monitor?** section, select **Kubernetes**, and then select **Elastic Agent: Logs & Metrics**.
    3. To install Elastic Agent on your host, copy and run the install command.
       By running this command, you use the Helm package manager to install and configure an instance of the Elastic Agent Helm chart with additional deployment-specific data such as the API key generated by Kibana for the acting user.
       The Helm chart also includes a default installation of [`kube-state-metrics` (KSM)](https://github.com/kubernetes/kube-state-metrics), which is required by the Kubernetes integration to collect cluster-level metrics.
       If you encounter an error during the installation, refer to [Troubleshooting](#monitor-k8s-with-agent-troubleshooting).
       <dropdown title="Details about the install command">
       The install command provided by the UI may be similar to:
       ```sh
       helm repo add elastic https://helm.elastic.co/ && helm install elastic-agent elastic/elastic-agent --version 9.3.0 -n kube-system --set outputs.default.url=https:<elasticsearch-url>:443 --set kubernetes.onboardingID=<internal-id> --set kubernetes.enabled=true --set outputs.default.type=ESPlainAuthAPI --set outputs.default.api_key=$(echo "<api-key>" | base64 -d)
       ```
       Where:
       - `elastic-agent` is the name of the specific installation of the Helm chart, known as **release name**.
       - `elastic/elastic-agent` defines the name of the chart to install, using the format `<repository>/<chart-name>`.
       - 9.3.0 is the version of the Elastic Agent Helm chart to be installed.
       - `kube-system` is the namespace where Elastic Agent is to be installed.
       - `--set` parameters add configuration values specific to the serverless project, the acting user, and the deployment method of the Helm chart.
       Refer to [Install standalone Elastic Agent on Kubernetes using Helm](/docs/reference/fleet/example-kubernetes-standalone-agent-helm#agent-standalone-helm-example-install) for a more detailed explanation of the configuration options used.
       </dropdown>
    4. Go back to the **Kubernetes: Logs & Metrics** page in Kibana.
       There might be a slight delay before data is ingested. When ready, you will see the message **We are monitoring your cluster**.
    5. Click **Explore Kubernetes cluster** to navigate to dashboards and explore your data.
  </applies-item>

  <applies-item title="stack: ga 9.2+" applies-to="Elastic Stack: Generally available since 9.2">
    1. In Kibana, go to the **Observability** overview page, and click **Add Data**.
    2. In the **What do you want to monitor?** section, select **Kubernetes**, and then select **Elastic Agent: Logs & Metrics**.
    3. To install Elastic Agent on your host, copy and run the install command.
       By running this command, you use the Helm package manager to install and configure an instance of the Elastic Agent Helm chart with additional deployment-specific data such as the API key generated by Kibana for the acting user.
       The Helm chart also includes a default installation of [`kube-state-metrics` (KSM)](https://github.com/kubernetes/kube-state-metrics), which is required by the Kubernetes integration to collect cluster-level metrics.
       If you encounter an error during the installation, refer to [Troubleshooting](#monitor-k8s-with-agent-troubleshooting).
       <dropdown title="Details about the install command">
       The install command provided by the UI may be similar to:
       ```sh
       helm repo add elastic https://helm.elastic.co/ && helm install elastic-agent elastic/elastic-agent --version 9.3.0 -n kube-system --set outputs.default.url=https:<elasticsearch-url>:443 --set kubernetes.onboardingID=<internal-id> --set kubernetes.enabled=true --set outputs.default.type=ESPlainAuthAPI --set outputs.default.api_key=$(echo "<api-key>" | base64 -d)
       ```
       Where:
       - `elastic-agent` is the name of the specific installation of the Helm chart, known as **release name**.
       - `elastic/elastic-agent` defines the name of the chart to install, using the format `<repository>/<chart-name>`.
       - 9.3.0 is the version of the Elastic Agent Helm chart to be installed.
       - `kube-system` is the namespace where Elastic Agent is to be installed.
       - `--set` parameters add configuration values specific to the serverless project, the acting user, and the deployment method of the Helm chart.
       Refer to [Install standalone Elastic Agent on Kubernetes using Helm](/docs/reference/fleet/example-kubernetes-standalone-agent-helm#agent-standalone-helm-example-install) for a more detailed explanation of the configuration options used.
       </dropdown>
    4. Go back to the **Kubernetes: Logs & Metrics** page in Kibana.
       There might be a slight delay before data is ingested. When ready, you will see the message **We are monitoring your cluster**.
    5. Click **Explore Kubernetes cluster** to navigate to dashboards and explore your data.
  </applies-item>

  <applies-item title="stack: ga 9.0-9.1" applies-to="Elastic Stack: Generally available from 9.0 to 9.1">
    1. In Kibana, go to the **Observability** UI and click **Add Data**.
    2. In the **What do you want to monitor?** section, select **Kubernetes**, and then select **Elastic Agent: Logs & Metrics**.
    3. To install Elastic Agent on your host, copy and run the install command.
       By running this command, you use `kubectl kustomize` to download a manifest file, inject deployment-specific data such as the API key generated by Kibana for the acting user, and create the Kubernetes resources for Elastic Agent.
    4. Go back to the **Kubernetes: Logs & Metrics** page in Kibana.
       There might be a slight delay before data is ingested. When ready, you will see the message **We are monitoring your cluster**.
    5. Click **Explore Kubernetes cluster** to navigate to dashboards and explore your data.
  </applies-item>
</applies-switch>


## Visualize your data

After installation is complete and all relevant data is flowing into Elastic, the **Visualize your data** section allows you to access the Kubernetes Cluster Overview dashboard that can be used to monitor the health of the cluster.
![Kubernetes overview dashboard](https://www.elastic.co/docs/solutions/images/observability-quickstart-k8s-overview.png)

Furthermore, you can access other useful prebuilt dashboards for monitoring Kubernetes resources, for example running pods per namespace, as well as the resources they consume, like CPU and memory.
Refer to [Observability overview](https://www.elastic.co/docs/solutions/observability) for a description of other useful features.

## Uninstall Elastic Agent from the Kubernetes cluster

<applies-switch>
  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    To uninstall Elastic Agent and the Kubernetes resources installed with Helm, run:
    ```sh
    helm uninstall <release-name> -n <namespace> 
    ```
    If you used the default values from the quickstart, the command would be:
    ```sh
    helm uninstall elastic-agent -n kube-system
    ```
  </applies-item>

  <applies-item title="stack: ga 9.2+" applies-to="Elastic Stack: Generally available since 9.2">
    To uninstall Elastic Agent and the Kubernetes resources installed with Helm, run:
    ```sh
    helm uninstall <release-name> -n <namespace> 
    ```
    If you used the default values from the quickstart, the command would be:
    ```sh
    helm uninstall elastic-agent -n kube-system
    ```
  </applies-item>

  <applies-item title="stack: ga 9.0-9.1" applies-to="Elastic Stack: Generally available from 9.0 to 9.1">
    To uninstall Elastic Agent and the Kubernetes resources installed with `kubectl`:
    1. Copy the `kubectl` quickstart command for installing Elastic Agent described in the [Collect your data](#_collect_your_data_2) section.
    2. Replace `| kubectl apply -f-` with `| kubectl delete -f-`, then run the command.
  </applies-item>
</applies-switch>


## Troubleshooting


### `kube-state-metrics` is already installed

If you're using `helm` to install Elastic Agent in your Kubernetes cluster, you may encounter an error if `kube-state-metrics` is already installed in the same namespace where Elastic Agent is to be installed. In this case, add the option `--set kube-state-metrics.enabled=false` to the install command provided by the UI to skip the installation of `kube-state-metrics`.

### The `elastic` repository already exists

If you're using `helm` to install Elastic Agent in your Kubernetes cluster and the `elastic` repository is already configured on your host, replace the `helm repo add elastic https://helm.elastic.co/ ` part of the command provided by the UI with `helm repo update elastic` to ensure the repository is updated with the latest package information.