﻿---
title: Quickstart: Monitor hosts with OpenTelemetry
description: Learn how to monitor hosts using the Elastic Distribution of OpenTelemetry (EDOT) Collector and gain deeper insights into your observability data.
url: https://www.elastic.co/docs/solutions/observability/get-started/quickstart-monitor-hosts-with-opentelemetry
products:
  - Elastic Cloud Serverless
  - Elastic Observability
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Quickstart: Monitor hosts with OpenTelemetry
In this quickstart guide, you’ll learn how to monitor your hosts using the Elastic Distribution of OpenTelemetry (EDOT) Collector. You’ll also learn how to use Observability features to gain deeper insight into your observability data after collecting it.

## Prerequisites

<applies-switch>
  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    - An Observability project. To learn more, refer to [Create an Observability project](https://www.elastic.co/docs/solutions/observability/get-started).
    - This quickstart is only available for Linux and MacOS systems.
    - A user with the **Admin** role or higher—required to onboard system logs and metrics. To learn more, refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles).
    - Root privileges on the host—required to run the OpenTelemetry collector because of these components:
      - `hostmetrics` receiver to read all system metrics (all processes, memory, etc.).
    - `filelog` to allow the collector to read any user or application log files.
  </applies-item>

  <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
    - An Elasticsearch cluster for storing and searching your data, and Kibana for visualizing and managing your data. This quickstart is available for all Elastic deployment models. To get started quickly, try out [Elastic Cloud](https://cloud.elastic.co/registration?page=docs&placement=docs-body).
    - This quickstart is only available for Linux and MacOS systems.
    - A user with the **Admin** role or higher—required to onboard system logs and metrics. To learn more, refer to [User roles and privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles).
    - Root privileges on the host—required to run the OpenTelemetry collector because of these components:
      - `hostmetrics` receiver to read all system metrics (all processes, memory, etc.).
    - `filelog` to allow the collector to read any user or application log files.
  </applies-item>
</applies-switch>


## Limitations

Refer to [Elastic OpenTelemetry Collector limitations](https://www.elastic.co/docs/reference/opentelemetry/compatibility/limitations) for known limitations when using the EDOT Collector.

## Collect your data

Follow these steps to collect logs and metrics using the EDOT Collector:
<applies-switch>
  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    1. [Create a new Elastic Observability Serverless project](https://www.elastic.co/docs/solutions/observability/get-started), or open an existing one.
    2. To open the quickstart, go to **Add Data**.
    3. Select **Collect and analyze logs**, and then select **OpenTelemetry**.
    4. Under **What do you want to monitor?** select **Host**, and then select **Elastic Agent: Logs & Metrics**.
       ![](https://www.elastic.co/docs/solutions/images/serverless-quickstart-monitor-hosts-otel-entry-point.png)

    1. Select the appropriate platform, and complete the following:
    2. For **MacOS and Linux**, copy the command, open a terminal on your host, and run the command to download and configure the OpenTelemetry collector.
    3. For **Kubernetes**, download the manifest.
    4. Copy the command under Step 2:
    5. For **MacOS and Linux**, run the command in your terminal to start the EDOT Collector.
    6. For **Kubernetes**, run the command from the directory where you downloaded the manifest to install the EDOT Collector on every node of your cluster.
    Logs are collected from setup onward, so you won’t see logs that occurred before starting the EDOT Collector. The default log path is `/var/log/*`. To update the path, modify `otel.yml`.
  </applies-item>

  <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
    1. In Kibana, go to the **Observability** UI and click **Add Data**.
    2. Under **What do you want to monitor?** select **Host**, and then select **OpenTelemetry: Logs & Metrics**.
       ![](https://www.elastic.co/docs/solutions/images/observability-quickstart-monitor-hosts-otel-entry-point.png)

    1. Select the appropriate platform.
    2. Copy the command under step 1, open a terminal on your host, and run the command.
       This command downloads the Elastic Agent package, extracts it in a EDOT directory. For example, `elastic-distro-8.16.0-linux-x86_64`. It also adds a sample `otel.yml` configuration file to the directory and updates the storage directory, Elastic endpoint, and API key in the file.
       The default log path is `/var/log/*.log`. To update the path, modify the `otel.yml` in the EDOT directory.
       Find additional sample `otel.yml` configuration files in the EDOT directory in the `otel_samples` folder.
    3. Copy the command under Step 2 and run it in your terminal to start the EDOT Collector.

    <note>
      Logs are collected from setup onward, so you won’t see logs that occurred before starting the EDOT Collector.
    </note>
  </applies-item>
</applies-switch>


## Gain deeper insight into your host data

After using the **Hosts** page and **Discover** to confirm you’ve ingested all the host logs and metrics you want to monitor, use Elastic Observability to gain deeper insight into your host data with the following capabilities and features:
- In the [Infrastructure UI](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics), analyze and compare data collected from your hosts. You can also:
  - [Detect anomalies](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/detect-metric-anomalies) for memory usage and network traffic on hosts.
- [Create alerts](https://www.elastic.co/docs/solutions/observability/incident-management/create-manage-rules) that notify you when an anomaly is detected or a metric exceeds a given value.
- In [Discover](https://www.elastic.co/docs/solutions/observability/logs/discover-logs), search and filter your log data, get information about the structure of log fields, and display your findings in a visualization. You can also:
  - [Monitor log data set quality](https://www.elastic.co/docs/solutions/observability/data-set-quality-monitoring) to find degraded documents.
- [Run a pattern analysis](/docs/explore-analyze/machine-learning/machine-learning-in-kibana/xpack-ml-aiops#log-pattern-analysis) to find patterns in unstructured log messages.
- [Create alerts](https://www.elastic.co/docs/solutions/observability/incident-management/create-manage-rules) that notify you when an Observability data type reaches or exceeds a given value.
- Use [machine learning](https://www.elastic.co/docs/explore-analyze/machine-learning/machine-learning-in-kibana) to apply predictive analytics to your data:
  - [Detect anomalies](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection) by comparing real-time and historical data from different sources to look for unusual, problematic patterns.
- [Analyze log spikes and drops](/docs/explore-analyze/machine-learning/machine-learning-in-kibana/xpack-ml-aiops#log-rate-analysis).
- [Detect change points](/docs/explore-analyze/machine-learning/machine-learning-in-kibana/xpack-ml-aiops#change-point-detection) in your time series data.

Refer to the [Elastic Observability](https://www.elastic.co/docs/solutions/observability) for a description of other useful features.