﻿---
title: Quickstart: Monitor hosts with Elastic Agent
description: Learn how to scan your host to detect and collect logs and metrics using Elastic Agent, and analyze your observability data with dashboards.
url: https://www.elastic.co/docs/solutions/observability/get-started/quickstart-monitor-hosts-with-elastic-agent
products:
  - Elastic Cloud Serverless
  - Elastic Observability
  - Elastic Stack
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Quickstart: Monitor hosts with Elastic Agent
In this quickstart guide, you’ll learn how to scan your host to detect and collect logs and metrics, then navigate to dashboards to further analyze and explore your observability data. You’ll also learn how to get value out of your observability data.
To scan your host, you’ll run an auto-detection script that downloads and installs Elastic Agent, which is used to collect observability data from the host and send it to Elastic.
The script also generates an Elastic Agent configuration file that you can use with your existing Infrastructure-as-Code tooling.
<tip>
  We recommend using the [Elastic Distribution of OpenTelemetry (EDOT) Collector](https://www.elastic.co/docs/solutions/observability/get-started/quickstart-monitor-hosts-with-opentelemetry) as the preferred way to collect system metrics and logs using OpenTelemetry.
</tip>


## Prerequisites

<applies-switch>
  <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
    - An Elasticsearch cluster for storing and searching your data, and Kibana for visualizing and managing your data. This quickstart is available for all Elastic deployment models. To get started quickly, try out [Elastic Cloud](https://cloud.elastic.co/registration?page=docs&placement=docs-body).
    - A user with the `superuser` [built-in role](https://www.elastic.co/docs/reference/elasticsearch/roles) or the privileges required to onboard data.
      <dropdown title="Expand to view required privileges">
      - [**Cluster**](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-cluster): `['monitor', 'manage_own_api_key']`
      - [**Index**](https://www.elastic.co/docs/reference/elasticsearch/security-privileges#privileges-list-indices): `{ names: ['logs-*-*', 'metrics-*-*'], privileges: ['auto_configure', 'create_doc'] }`
      - [**Kibana**](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges): `{ spaces: ['*'], feature: { fleet: ['all'], fleetv2: ['all'] } }`
      </dropdown>
    - Root privileges on the host—required to run the auto-detection script used in this quickstart.
  </applies-item>

  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    - An Elastic Observability Serverless project. To learn more, refer to [Create an Observability project](https://www.elastic.co/docs/solutions/observability/get-started).
    - An Elastic deployment. If you don’t have one yet, go to [cloud.elastic.co](https://cloud.elastic.co/). Within **Hosted deployments**, select **Create hosted deployment**.
    - A user with the **Admin** role or higher—required to onboard system logs and metrics. To learn more, refer to [Assign user roles and privileges](/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles).
    - Root privileges on the host—required to run the auto-detection script used in this quickstart.
  </applies-item>
</applies-switch>


## Limitations

- The auto-detection script works on Linux and MacOS only. Support for the `lsof` command is also required if you want to detect custom log files.
- If you’ve installed Apache or Nginx in a non-standard location, you’ll need to specify log file paths manually when you run the scan.
- Because Docker Desktop runs in a VM, its host-level logs and metrics are not auto-detected.


## Collect your data

<applies-switch>
  <applies-item title="stack:" applies-to="Elastic Stack: Generally available">
    1. In Kibana, go to the **Observability** UI and click **Add Data**.
    2. Under **What do you want to monitor?** select **Host**, and then select **Elastic Agent: Logs & Metrics**.
    3. Copy the install command.
       You’ll run this command to download the auto-detection script, scan your system for observability data, and install Elastic Agent.
       <tip>
       If you've previously installed Elastic Agent, you may need to uninstall it first:`sudo elastic-agent uninstall`If uninstalling fails or the agent is stuck, rerun the install with the `--force` flag.
       </tip>
    4. Open a terminal on the host you want to scan, and run the command.
    5. Review the list of log files:
       - Enter `Y` to ingest all the log files listed.
    - Enter `n` to either exclude log files or specify additional log paths. Enter `Y` to confirm your selections.
  </applies-item>

  <applies-item title="serverless:" applies-to="Elastic Cloud Serverless: Generally available">
    1. [Create a new Elastic Observability Serverless project](https://www.elastic.co/docs/solutions/observability/get-started), or open an existing one.
    2. In your Elastic Observability Serverless project, go to **Add Data**.
    3. Under **What do you want to monitor?** select **Host**, and then select **Elastic Agent: Logs & Metrics**.
    4. Copy the install command.
       You’ll run this command to download the auto-detection script, scan your system for observability data, and install Elastic Agent.
       <tip>
       If you've previously installed Elastic Agent, you may need to uninstall it first:`sudo elastic-agent uninstall`If uninstalling fails or the agent is stuck, rerun the install with the `--force` flag.
       </tip>
    5. Open a terminal on the host you want to scan, and run the command.
    6. Review the list of log files:
       - Enter `Y` to ingest all the log files listed.
    - Enter `n` to either exclude log files or specify additional log paths. Enter `Y` to confirm your selections.
  </applies-item>
</applies-switch>

When the script is done, you’ll see a message like "Elastic Agent is configured and running."
There might be a slight delay before logs and other data are ingested.
<note>
  **Need to scan your host again?**The auto-detection script (`auto_detect.sh`) is downloaded to the directory where you ran the installation command. You can re-run the script on the same host to detect additional logs. The script will scan the host and reconfigure Elastic Agent with any additional logs that are found. If the script misses any custom logs, you can add them manually by entering `n` after the script has finished scanning the host.
</note>


## Visualize your data

After installation is complete and all relevant data is flowing into Elastic, the **Visualize your data** section will show links to assets you can use to analyze your data. Depending on what type of observability data was collected, the page may link to the following integration assets:

| Integration asset             | Description                                                                                                                                                                       |
|-------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Apache**                    | Prebuilt dashboard for monitoring Apache HTTP server health using error and access log data.                                                                                      |
| **Custom .log files**         | Discover for analyzing custom logs.                                                                                                                                               |
| **Docker**                    | Prebuilt dashboard for monitoring the status and health of Docker containers.                                                                                                     |
| **MySQL**                     | Prebuilt dashboard for monitoring MySQl server health using error and access log data.                                                                                            |
| **Nginx**                     | Prebuilt dashboard for monitoring Nginx server health using error and access log data.                                                                                            |
| **System**                    | Prebuilt dashboard for monitoring host status and health using system metrics.                                                                                                    |
| **Other prebuilt dashboards** | Prebuilt dashboards are also available for systems and services not described here,including PostgreSQL, Redis, HAProxy, Kafka, RabbitMQ, Prometheus, Apache Tomcat, and MongoDB. |

For example, you can navigate the **Host overview** dashboard to explore detailed metrics about system usage and throughput. Metrics that indicate a possible problem are highlighted in red.

## Get value out of your data

After using the dashboards to examine your data and confirm you’ve ingested all the host logs and metrics you want to monitor, you can use Elastic Observability to gain deeper insight into your data.
For host monitoring, the following capabilities and features are recommended:
- In the [Infrastructure UI](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/analyze-infrastructure-host-metrics), analyze and compare data collected from your hosts. You can also:
  - [Detect anomalies](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/detect-metric-anomalies) for memory usage and network traffic on hosts.
- [Create alerts](https://www.elastic.co/docs/solutions/observability/incident-management/alerting) that notify you when an anomaly is detected or a metric exceeds a given value.
- In [Discover](https://www.elastic.co/docs/solutions/observability/logs/discover-logs), search and filter your log data, get information about the structure of log fields, and display your findings in a visualization. You can also:
  - [Monitor log data set quality](https://www.elastic.co/docs/solutions/observability/data-set-quality-monitoring) to find degraded documents.
- [Run a pattern analysis](/docs/explore-analyze/machine-learning/machine-learning-in-kibana/xpack-ml-aiops#log-pattern-analysis) to find patterns in unstructured log messages.
- [Create alerts](https://www.elastic.co/docs/solutions/observability/incident-management/alerting) that notify you when an Observability data type reaches or exceeds a given value.
- Use [machine learning](https://www.elastic.co/docs/explore-analyze/machine-learning/machine-learning-in-kibana) to apply predictive analytics to your data:
  - [Detect anomalies](https://www.elastic.co/docs/explore-analyze/machine-learning/anomaly-detection) by comparing real-time and historical data from different sources to look for unusual, problematic patterns.
- [Analyze log spikes and drops](/docs/explore-analyze/machine-learning/machine-learning-in-kibana/xpack-ml-aiops#log-rate-analysis).
- [Detect change points](/docs/explore-analyze/machine-learning/machine-learning-in-kibana/xpack-ml-aiops#change-point-detection) in your time series data.

Refer to the [Observability overview](https://www.elastic.co/docs/solutions/observability) for a description of other useful features.

## Manage your data

Now that you're ingesting data and using it gather insights, learn how to manage your [data lifecycle](https://www.elastic.co/docs/manage-data/lifecycle). These features in Elasticsearch allow you to govern how long your Elastic Agent data is retained, and to tune performance by configuring background operations that optimize how your data is stored.